/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 location where the source code files provided with the project request are stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Location implements SdkPojo, Serializable, ToCopyableBuilder<S3Location.Builder, S3Location> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Location::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUCKET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Location::bucketKey)).setter(setter(Builder::bucketKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketKey;

    private S3Location(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketKey = builder.bucketKey;
    }

    /**
     * <p>
     * The Amazon S3 bucket name where the source code files provided with the project request are stored.
     * </p>
     * 
     * @return The Amazon S3 bucket name where the source code files provided with the project request are stored.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The Amazon S3 object key where the source code files provided with the project request are stored.
     * </p>
     * 
     * @return The Amazon S3 object key where the source code files provided with the project request are stored.
     */
    public String bucketKey() {
        return bucketKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketKey(), other.bucketKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3Location").add("BucketName", bucketName()).add("BucketKey", bucketKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bucketKey":
            return Optional.ofNullable(clazz.cast(bucketKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Location> {
        /**
         * <p>
         * The Amazon S3 bucket name where the source code files provided with the project request are stored.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket name where the source code files provided with the project request are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The Amazon S3 object key where the source code files provided with the project request are stored.
         * </p>
         * 
         * @param bucketKey
         *        The Amazon S3 object key where the source code files provided with the project request are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketKey(String bucketKey);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            bucketName(model.bucketName);
            bucketKey(model.bucketKey);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getBucketKey() {
            return bucketKey;
        }

        @Override
        public final Builder bucketKey(String bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        public final void setBucketKey(String bucketKey) {
            this.bucketKey = bucketKey;
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
