/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForThirdPartyJobsRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PollForThirdPartyJobsRequest> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PollForThirdPartyJobsRequest.getter(PollForThirdPartyJobsRequest::actionTypeId)).setter(PollForThirdPartyJobsRequest.setter(Builder::actionTypeId)).constructor(ActionTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()}).build();
    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PollForThirdPartyJobsRequest.getter(PollForThirdPartyJobsRequest::maxBatchSize)).setter(PollForThirdPartyJobsRequest.setter(Builder::maxBatchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD, MAX_BATCH_SIZE_FIELD));
    private final ActionTypeId actionTypeId;
    private final Integer maxBatchSize;

    private PollForThirdPartyJobsRequest(BuilderImpl builder) {
        super(builder);
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForThirdPartyJobsRequest)) {
            return false;
        }
        PollForThirdPartyJobsRequest other = (PollForThirdPartyJobsRequest)((Object)obj);
        return Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.maxBatchSize(), other.maxBatchSize());
    }

    public String toString() {
        return ToString.builder((String)"PollForThirdPartyJobsRequest").add("ActionTypeId", (Object)this.actionTypeId()).add("MaxBatchSize", (Object)this.maxBatchSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypeId": {
                return Optional.ofNullable(clazz.cast(this.actionTypeId()));
            }
            case "maxBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maxBatchSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForThirdPartyJobsRequest, T> g) {
        return obj -> g.apply((PollForThirdPartyJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private Integer maxBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForThirdPartyJobsRequest model) {
            super(model);
            this.actionTypeId(model.actionTypeId);
            this.maxBatchSize(model.maxBatchSize);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForThirdPartyJobsRequest build() {
            return new PollForThirdPartyJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForThirdPartyJobsRequest> {
        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().applyMutation(actionTypeId)).build());
        }

        public Builder maxBatchSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

