/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.ActionType;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;

public class ListActionTypesIterable
implements SdkIterable<ListActionTypesResponse> {
    private final CodePipelineClient client;
    private final ListActionTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActionTypesIterable(CodePipelineClient client, ListActionTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActionTypesResponseFetcher();
    }

    public Iterator<ListActionTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionType> actionTypes() {
        Function<ListActionTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionTypes() != null) {
                return response.actionTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActionTypesResponseFetcher
    implements SyncPageFetcher<ListActionTypesResponse> {
        private ListActionTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListActionTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActionTypesResponse nextPage(ListActionTypesResponse previousPage) {
            if (previousPage == null) {
                return ListActionTypesIterable.this.client.listActionTypes(ListActionTypesIterable.this.firstRequest);
            }
            return ListActionTypesIterable.this.client.listActionTypes((ListActionTypesRequest)((Object)ListActionTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

