/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria;
import software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria;
import software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventType;
import software.amazon.awssdk.services.codepipeline.model.GitPullRequestEventTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitPullRequestFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitPullRequestFilter> {
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(GitPullRequestFilter.getter(GitPullRequestFilter::eventsAsStrings)).setter(GitPullRequestFilter.setter(Builder::eventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GitBranchFilterCriteria> BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("branches").getter(GitPullRequestFilter.getter(GitPullRequestFilter::branches)).setter(GitPullRequestFilter.setter(Builder::branches)).constructor(GitBranchFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build()}).build();
    private static final SdkField<GitFilePathFilterCriteria> FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filePaths").getter(GitPullRequestFilter.getter(GitPullRequestFilter::filePaths)).setter(GitPullRequestFilter.setter(Builder::filePaths)).constructor(GitFilePathFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePaths").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, BRANCHES_FIELD, FILE_PATHS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> events;
    private final GitBranchFilterCriteria branches;
    private final GitFilePathFilterCriteria filePaths;

    private GitPullRequestFilter(BuilderImpl builder) {
        this.events = builder.events;
        this.branches = builder.branches;
        this.filePaths = builder.filePaths;
    }

    public final List<GitPullRequestEventType> events() {
        return GitPullRequestEventTypeListCopier.copyStringToEnum(this.events);
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<String> eventsAsStrings() {
        return this.events;
    }

    public final GitBranchFilterCriteria branches() {
        return this.branches;
    }

    public final GitFilePathFilterCriteria filePaths() {
        return this.filePaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.eventsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.branches());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePaths());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPullRequestFilter)) {
            return false;
        }
        GitPullRequestFilter other = (GitPullRequestFilter)obj;
        return this.hasEvents() == other.hasEvents() && Objects.equals(this.eventsAsStrings(), other.eventsAsStrings()) && Objects.equals(this.branches(), other.branches()) && Objects.equals(this.filePaths(), other.filePaths());
    }

    public final String toString() {
        return ToString.builder((String)"GitPullRequestFilter").add("Events", this.hasEvents() ? this.eventsAsStrings() : null).add("Branches", (Object)this.branches()).add("FilePaths", (Object)this.filePaths()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "events": {
                return Optional.ofNullable(clazz.cast(this.eventsAsStrings()));
            }
            case "branches": {
                return Optional.ofNullable(clazz.cast(this.branches()));
            }
            case "filePaths": {
                return Optional.ofNullable(clazz.cast(this.filePaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitPullRequestFilter, T> g) {
        return obj -> g.apply((GitPullRequestFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> events = DefaultSdkAutoConstructList.getInstance();
        private GitBranchFilterCriteria branches;
        private GitFilePathFilterCriteria filePaths;

        private BuilderImpl() {
        }

        private BuilderImpl(GitPullRequestFilter model) {
            this.eventsWithStrings(model.events);
            this.branches(model.branches);
            this.filePaths(model.filePaths);
        }

        public final Collection<String> getEvents() {
            if (this.events instanceof SdkAutoConstructList) {
                return null;
            }
            return this.events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = GitPullRequestEventTypeListCopier.copy(events);
        }

        @Override
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = GitPullRequestEventTypeListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsWithStrings(String ... events) {
            this.eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        public final Builder events(Collection<GitPullRequestEventType> events) {
            this.events = GitPullRequestEventTypeListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(GitPullRequestEventType ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final GitBranchFilterCriteria.Builder getBranches() {
            return this.branches != null ? this.branches.toBuilder() : null;
        }

        public final void setBranches(GitBranchFilterCriteria.BuilderImpl branches) {
            this.branches = branches != null ? branches.build() : null;
        }

        @Override
        public final Builder branches(GitBranchFilterCriteria branches) {
            this.branches = branches;
            return this;
        }

        public final GitFilePathFilterCriteria.Builder getFilePaths() {
            return this.filePaths != null ? this.filePaths.toBuilder() : null;
        }

        public final void setFilePaths(GitFilePathFilterCriteria.BuilderImpl filePaths) {
            this.filePaths = filePaths != null ? filePaths.build() : null;
        }

        @Override
        public final Builder filePaths(GitFilePathFilterCriteria filePaths) {
            this.filePaths = filePaths;
            return this;
        }

        public GitPullRequestFilter build() {
            return new GitPullRequestFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitPullRequestFilter> {
        public Builder eventsWithStrings(Collection<String> var1);

        public Builder eventsWithStrings(String ... var1);

        public Builder events(Collection<GitPullRequestEventType> var1);

        public Builder events(GitPullRequestEventType ... var1);

        public Builder branches(GitBranchFilterCriteria var1);

        default public Builder branches(Consumer<GitBranchFilterCriteria.Builder> branches) {
            return this.branches((GitBranchFilterCriteria)((GitBranchFilterCriteria.Builder)GitBranchFilterCriteria.builder().applyMutation(branches)).build());
        }

        public Builder filePaths(GitFilePathFilterCriteria var1);

        default public Builder filePaths(Consumer<GitFilePathFilterCriteria.Builder> filePaths) {
            return this.filePaths((GitFilePathFilterCriteria)((GitFilePathFilterCriteria.Builder)GitFilePathFilterCriteria.builder().applyMutation(filePaths)).build());
        }
    }
}

