/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TriggerType {
    CREATE_PIPELINE("CreatePipeline"),
    START_PIPELINE_EXECUTION("StartPipelineExecution"),
    POLL_FOR_SOURCE_CHANGES("PollForSourceChanges"),
    WEBHOOK("Webhook"),
    CLOUD_WATCH_EVENT("CloudWatchEvent"),
    PUT_ACTION_REVISION("PutActionRevision"),
    WEBHOOK_V2("WebhookV2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TriggerType> VALUE_MAP;
    private final String value;

    private TriggerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TriggerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TriggerType> knownValues() {
        EnumSet<TriggerType> knownValues = EnumSet.allOf(TriggerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TriggerType.class, TriggerType::toString);
    }
}

