/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClientBuilder;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineBaseClientBuilder;
import software.amazon.awssdk.services.codepipeline.endpoints.CodePipelineEndpointProvider;

@SdkInternalApi
final class DefaultCodePipelineAsyncClientBuilder
extends DefaultCodePipelineBaseClientBuilder<CodePipelineAsyncClientBuilder, CodePipelineAsyncClient>
implements CodePipelineAsyncClientBuilder {
    DefaultCodePipelineAsyncClientBuilder() {
    }

    @Override
    public DefaultCodePipelineAsyncClientBuilder endpointProvider(CodePipelineEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodePipelineAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodePipelineAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodePipelineServiceClientConfiguration serviceClientConfiguration = CodePipelineServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodePipelineAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

