/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.Artifact;

final class ArtifactListCopier {
    ArtifactListCopier() {
    }

    static List<Artifact> copy(Collection<? extends Artifact> artifactListParam) {
        Object list;
        if (artifactListParam == null || artifactListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            artifactListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Artifact> copyFromBuilder(Collection<? extends Artifact.Builder> artifactListParam) {
        Object list;
        if (artifactListParam == null || artifactListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            artifactListParam.forEach(entry -> {
                Artifact member = entry == null ? null : (Artifact)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Artifact.Builder> copyToBuilder(Collection<? extends Artifact> artifactListParam) {
        Object list;
        if (artifactListParam == null || artifactListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            artifactListParam.forEach(entry -> {
                Artifact.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

