/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceRevision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceRevision> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(SourceRevision.getter(SourceRevision::actionName)).setter(SourceRevision.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(SourceRevision.getter(SourceRevision::revisionId)).setter(SourceRevision.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> REVISION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionSummary").getter(SourceRevision.getter(SourceRevision::revisionSummary)).setter(SourceRevision.setter(Builder::revisionSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionSummary").build()}).build();
    private static final SdkField<String> REVISION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionUrl").getter(SourceRevision.getter(SourceRevision::revisionUrl)).setter(SourceRevision.setter(Builder::revisionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, REVISION_ID_FIELD, REVISION_SUMMARY_FIELD, REVISION_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final String revisionId;
    private final String revisionSummary;
    private final String revisionUrl;

    private SourceRevision(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.revisionId = builder.revisionId;
        this.revisionSummary = builder.revisionSummary;
        this.revisionUrl = builder.revisionUrl;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String revisionSummary() {
        return this.revisionSummary;
    }

    public final String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRevision)) {
            return false;
        }
        SourceRevision other = (SourceRevision)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.revisionSummary(), other.revisionSummary()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public final String toString() {
        return ToString.builder((String)"SourceRevision").add("ActionName", (Object)this.actionName()).add("RevisionId", (Object)this.revisionId()).add("RevisionSummary", (Object)this.revisionSummary()).add("RevisionUrl", (Object)this.revisionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "revisionSummary": {
                return Optional.ofNullable(clazz.cast(this.revisionSummary()));
            }
            case "revisionUrl": {
                return Optional.ofNullable(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceRevision, T> g) {
        return obj -> g.apply((SourceRevision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private String revisionId;
        private String revisionSummary;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRevision model) {
            this.actionName(model.actionName);
            this.revisionId(model.revisionId);
            this.revisionSummary(model.revisionSummary);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        @Transient
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        @Override
        @Transient
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        @Transient
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public SourceRevision build() {
            return new SourceRevision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceRevision> {
        public Builder actionName(String var1);

        public Builder revisionId(String var1);

        public Builder revisionSummary(String var1);

        public Builder revisionUrl(String var1);
    }
}

