/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebhookAuthConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebhookAuthConfiguration> {
    private static final SdkField<String> ALLOWED_IP_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedIPRange").getter(WebhookAuthConfiguration.getter(WebhookAuthConfiguration::allowedIPRange)).setter(WebhookAuthConfiguration.setter(Builder::allowedIPRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIPRange").build()}).build();
    private static final SdkField<String> SECRET_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretToken").getter(WebhookAuthConfiguration.getter(WebhookAuthConfiguration::secretToken)).setter(WebhookAuthConfiguration.setter(Builder::secretToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_IP_RANGE_FIELD, SECRET_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allowedIPRange;
    private final String secretToken;

    private WebhookAuthConfiguration(BuilderImpl builder) {
        this.allowedIPRange = builder.allowedIPRange;
        this.secretToken = builder.secretToken;
    }

    public final String allowedIPRange() {
        return this.allowedIPRange;
    }

    public final String secretToken() {
        return this.secretToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedIPRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookAuthConfiguration)) {
            return false;
        }
        WebhookAuthConfiguration other = (WebhookAuthConfiguration)obj;
        return Objects.equals(this.allowedIPRange(), other.allowedIPRange()) && Objects.equals(this.secretToken(), other.secretToken());
    }

    public final String toString() {
        return ToString.builder((String)"WebhookAuthConfiguration").add("AllowedIPRange", (Object)this.allowedIPRange()).add("SecretToken", (Object)this.secretToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedIPRange": {
                return Optional.ofNullable(clazz.cast(this.allowedIPRange()));
            }
            case "SecretToken": {
                return Optional.ofNullable(clazz.cast(this.secretToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebhookAuthConfiguration, T> g) {
        return obj -> g.apply((WebhookAuthConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allowedIPRange;
        private String secretToken;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookAuthConfiguration model) {
            this.allowedIPRange(model.allowedIPRange);
            this.secretToken(model.secretToken);
        }

        public final String getAllowedIPRange() {
            return this.allowedIPRange;
        }

        public final void setAllowedIPRange(String allowedIPRange) {
            this.allowedIPRange = allowedIPRange;
        }

        @Override
        @Transient
        public final Builder allowedIPRange(String allowedIPRange) {
            this.allowedIPRange = allowedIPRange;
            return this;
        }

        public final String getSecretToken() {
            return this.secretToken;
        }

        public final void setSecretToken(String secretToken) {
            this.secretToken = secretToken;
        }

        @Override
        @Transient
        public final Builder secretToken(String secretToken) {
            this.secretToken = secretToken;
            return this;
        }

        public WebhookAuthConfiguration build() {
            return new WebhookAuthConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebhookAuthConfiguration> {
        public Builder allowedIPRange(String var1);

        public Builder secretToken(String var1);
    }
}

