/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutApprovalResult</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutApprovalResultRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PutApprovalResultRequest.Builder, PutApprovalResultRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(PutApprovalResultRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(PutApprovalResultRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(PutApprovalResultRequest::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<ApprovalResult> RESULT_FIELD = SdkField.<ApprovalResult> builder(MarshallingType.SDK_POJO)
            .memberName("result").getter(getter(PutApprovalResultRequest::result)).setter(setter(Builder::result))
            .constructor(ApprovalResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(PutApprovalResultRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_NAME_FIELD, ACTION_NAME_FIELD, RESULT_FIELD, TOKEN_FIELD));

    private final String pipelineName;

    private final String stageName;

    private final String actionName;

    private final ApprovalResult result;

    private final String token;

    private PutApprovalResultRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.result = builder.result;
        this.token = builder.token;
    }

    /**
     * <p>
     * The name of the pipeline that contains the action.
     * </p>
     * 
     * @return The name of the pipeline that contains the action.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The name of the stage that contains the action.
     * </p>
     * 
     * @return The name of the stage that contains the action.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The name of the action for which approval is requested.
     * </p>
     * 
     * @return The name of the action for which approval is requested.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * Represents information about the result of the approval request.
     * </p>
     * 
     * @return Represents information about the result of the approval request.
     */
    public final ApprovalResult result() {
        return result;
    }

    /**
     * <p>
     * The system-generated token used to identify a unique approval request. The token for each open approval request
     * can be obtained using the <a>GetPipelineState</a> action. It is used to validate that the approval request
     * corresponding to this token is still valid.
     * </p>
     * 
     * @return The system-generated token used to identify a unique approval request. The token for each open approval
     *         request can be obtained using the <a>GetPipelineState</a> action. It is used to validate that the
     *         approval request corresponding to this token is still valid.
     */
    public final String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApprovalResultRequest)) {
            return false;
        }
        PutApprovalResultRequest other = (PutApprovalResultRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(result(), other.result())
                && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutApprovalResultRequest").add("PipelineName", pipelineName()).add("StageName", stageName())
                .add("ActionName", actionName()).add("Result", result()).add("Token", token()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutApprovalResultRequest, T> g) {
        return obj -> g.apply((PutApprovalResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutApprovalResultRequest> {
        /**
         * <p>
         * The name of the pipeline that contains the action.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline that contains the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The name of the stage that contains the action.
         * </p>
         * 
         * @param stageName
         *        The name of the stage that contains the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The name of the action for which approval is requested.
         * </p>
         * 
         * @param actionName
         *        The name of the action for which approval is requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * Represents information about the result of the approval request.
         * </p>
         * 
         * @param result
         *        Represents information about the result of the approval request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(ApprovalResult result);

        /**
         * <p>
         * Represents information about the result of the approval request.
         * </p>
         * This is a convenience that creates an instance of the {@link ApprovalResult.Builder} avoiding the need to
         * create one manually via {@link ApprovalResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApprovalResult.Builder#build()} is called immediately and its
         * result is passed to {@link #result(ApprovalResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link ApprovalResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(ApprovalResult)
         */
        default Builder result(Consumer<ApprovalResult.Builder> result) {
            return result(ApprovalResult.builder().applyMutation(result).build());
        }

        /**
         * <p>
         * The system-generated token used to identify a unique approval request. The token for each open approval
         * request can be obtained using the <a>GetPipelineState</a> action. It is used to validate that the approval
         * request corresponding to this token is still valid.
         * </p>
         * 
         * @param token
         *        The system-generated token used to identify a unique approval request. The token for each open
         *        approval request can be obtained using the <a>GetPipelineState</a> action. It is used to validate that
         *        the approval request corresponding to this token is still valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String stageName;

        private String actionName;

        private ApprovalResult result;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApprovalResultRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            stageName(model.stageName);
            actionName(model.actionName);
            result(model.result);
            token(model.token);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ApprovalResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        @Override
        public final Builder result(ApprovalResult result) {
            this.result = result;
            return this;
        }

        public final void setResult(ApprovalResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApprovalResultRequest build() {
            return new PutApprovalResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
