/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a pipeline to a job worker.
 * </p>
 * <note>
 * <p>
 * PipelineContext contains <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom action jobs. The
 * <code>pipelineArn</code> and <code>pipelineExecutionId</code> fields are not populated for ThirdParty action jobs.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineContext implements SdkPojo, Serializable, ToCopyableBuilder<PipelineContext.Builder, PipelineContext> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(PipelineContext::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<StageContext> STAGE_FIELD = SdkField.<StageContext> builder(MarshallingType.SDK_POJO)
            .memberName("stage").getter(getter(PipelineContext::stage)).setter(setter(Builder::stage))
            .constructor(StageContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<ActionContext> ACTION_FIELD = SdkField.<ActionContext> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(PipelineContext::action)).setter(setter(Builder::action))
            .constructor(ActionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineArn").getter(getter(PipelineContext::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineArn").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(PipelineContext::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_FIELD, ACTION_FIELD, PIPELINE_ARN_FIELD, PIPELINE_EXECUTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineName;

    private final StageContext stage;

    private final ActionContext action;

    private final String pipelineArn;

    private final String pipelineExecutionId;

    private PipelineContext(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stage = builder.stage;
        this.action = builder.action;
        this.pipelineArn = builder.pipelineArn;
        this.pipelineExecutionId = builder.pipelineExecutionId;
    }

    /**
     * <p>
     * The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names
     * under an Amazon Web Services account.
     * </p>
     * 
     * @return The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all
     *         pipeline names under an Amazon Web Services account.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The stage of the pipeline.
     * </p>
     * 
     * @return The stage of the pipeline.
     */
    public final StageContext stage() {
        return stage;
    }

    /**
     * <p>
     * The context of an action to a job worker in the stage of a pipeline.
     * </p>
     * 
     * @return The context of an action to a job worker in the stage of a pipeline.
     */
    public final ActionContext action() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The execution ID of the pipeline.
     * </p>
     * 
     * @return The execution ID of the pipeline.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineContext)) {
            return false;
        }
        PipelineContext other = (PipelineContext) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stage(), other.stage())
                && Objects.equals(action(), other.action()) && Objects.equals(pipelineArn(), other.pipelineArn())
                && Objects.equals(pipelineExecutionId(), other.pipelineExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineContext").add("PipelineName", pipelineName()).add("Stage", stage())
                .add("Action", action()).add("PipelineArn", pipelineArn()).add("PipelineExecutionId", pipelineExecutionId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "pipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineContext, T> g) {
        return obj -> g.apply((PipelineContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineContext> {
        /**
         * <p>
         * The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline
         * names under an Amazon Web Services account.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all
         *        pipeline names under an Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The stage of the pipeline.
         * </p>
         * 
         * @param stage
         *        The stage of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(StageContext stage);

        /**
         * <p>
         * The stage of the pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link StageContext.Builder} avoiding the need to
         * create one manually via {@link StageContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link StageContext.Builder#build()} is called immediately and its
         * result is passed to {@link #stage(StageContext)}.
         * 
         * @param stage
         *        a consumer that will call methods on {@link StageContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stage(StageContext)
         */
        default Builder stage(Consumer<StageContext.Builder> stage) {
            return stage(StageContext.builder().applyMutation(stage).build());
        }

        /**
         * <p>
         * The context of an action to a job worker in the stage of a pipeline.
         * </p>
         * 
         * @param action
         *        The context of an action to a job worker in the stage of a pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ActionContext action);

        /**
         * <p>
         * The context of an action to a job worker in the stage of a pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionContext.Builder} avoiding the need to
         * create one manually via {@link ActionContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionContext.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ActionContext)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ActionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ActionContext)
         */
        default Builder action(Consumer<ActionContext.Builder> action) {
            return action(ActionContext.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The execution ID of the pipeline.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The execution ID of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineName;

        private StageContext stage;

        private ActionContext action;

        private String pipelineArn;

        private String pipelineExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineContext model) {
            pipelineName(model.pipelineName);
            stage(model.stage);
            action(model.action);
            pipelineArn(model.pipelineArn);
            pipelineExecutionId(model.pipelineExecutionId);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final StageContext.Builder getStage() {
            return stage != null ? stage.toBuilder() : null;
        }

        @Override
        public final Builder stage(StageContext stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(StageContext.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        public final ActionContext.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        @Override
        public final Builder action(ActionContext action) {
            this.action = action;
            return this;
        }

        public final void setAction(ActionContext.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public PipelineContext build() {
            return new PipelineContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
