/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListPipelineExecutions</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelineExecutionsResponse extends CodePipelineResponse implements
        ToCopyableBuilder<ListPipelineExecutionsResponse.Builder, ListPipelineExecutionsResponse> {
    private static final SdkField<List<PipelineExecutionSummary>> PIPELINE_EXECUTION_SUMMARIES_FIELD = SdkField
            .<List<PipelineExecutionSummary>> builder(MarshallingType.LIST)
            .memberName("pipelineExecutionSummaries")
            .getter(getter(ListPipelineExecutionsResponse::pipelineExecutionSummaries))
            .setter(setter(Builder::pipelineExecutionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPipelineExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PIPELINE_EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<PipelineExecutionSummary> pipelineExecutionSummaries;

    private final String nextToken;

    private ListPipelineExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionSummaries = builder.pipelineExecutionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PipelineExecutionSummaries property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasPipelineExecutionSummaries() {
        return pipelineExecutionSummaries != null && !(pipelineExecutionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of executions in the history of a pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineExecutionSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of executions in the history of a pipeline.
     */
    public final List<PipelineExecutionSummary> pipelineExecutionSummaries() {
        return pipelineExecutionSummaries;
    }

    /**
     * <p>
     * A token that can be used in the next <code>ListPipelineExecutions</code> call. To view all items in the list,
     * continue to call this operation with each subsequent token until no more nextToken values are returned.
     * </p>
     * 
     * @return A token that can be used in the next <code>ListPipelineExecutions</code> call. To view all items in the
     *         list, continue to call this operation with each subsequent token until no more nextToken values are
     *         returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineExecutionSummaries() ? pipelineExecutionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineExecutionsResponse)) {
            return false;
        }
        ListPipelineExecutionsResponse other = (ListPipelineExecutionsResponse) obj;
        return hasPipelineExecutionSummaries() == other.hasPipelineExecutionSummaries()
                && Objects.equals(pipelineExecutionSummaries(), other.pipelineExecutionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelineExecutionsResponse")
                .add("PipelineExecutionSummaries", hasPipelineExecutionSummaries() ? pipelineExecutionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineExecutionSummaries":
            return Optional.ofNullable(clazz.cast(pipelineExecutionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineExecutionsResponse, T> g) {
        return obj -> g.apply((ListPipelineExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPipelineExecutionsResponse> {
        /**
         * <p>
         * A list of executions in the history of a pipeline.
         * </p>
         * 
         * @param pipelineExecutionSummaries
         *        A list of executions in the history of a pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> pipelineExecutionSummaries);

        /**
         * <p>
         * A list of executions in the history of a pipeline.
         * </p>
         * 
         * @param pipelineExecutionSummaries
         *        A list of executions in the history of a pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionSummaries(PipelineExecutionSummary... pipelineExecutionSummaries);

        /**
         * <p>
         * A list of executions in the history of a pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineExecutionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<PipelineExecutionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineExecutionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelineExecutionSummaries(List<PipelineExecutionSummary>)}.
         * 
         * @param pipelineExecutionSummaries
         *        a consumer that will call methods on {@link List<PipelineExecutionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineExecutionSummaries(List<PipelineExecutionSummary>)
         */
        Builder pipelineExecutionSummaries(Consumer<PipelineExecutionSummary.Builder>... pipelineExecutionSummaries);

        /**
         * <p>
         * A token that can be used in the next <code>ListPipelineExecutions</code> call. To view all items in the list,
         * continue to call this operation with each subsequent token until no more nextToken values are returned.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used in the next <code>ListPipelineExecutions</code> call. To view all items in
         *        the list, continue to call this operation with each subsequent token until no more nextToken values
         *        are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<PipelineExecutionSummary> pipelineExecutionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineExecutionsResponse model) {
            super(model);
            pipelineExecutionSummaries(model.pipelineExecutionSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<PipelineExecutionSummary.Builder> getPipelineExecutionSummaries() {
            if (pipelineExecutionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return pipelineExecutionSummaries != null ? pipelineExecutionSummaries.stream()
                    .map(PipelineExecutionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copy(pipelineExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSummaries(PipelineExecutionSummary... pipelineExecutionSummaries) {
            pipelineExecutionSummaries(Arrays.asList(pipelineExecutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSummaries(Consumer<PipelineExecutionSummary.Builder>... pipelineExecutionSummaries) {
            pipelineExecutionSummaries(Stream.of(pipelineExecutionSummaries)
                    .map(c -> PipelineExecutionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineExecutionSummaries(
                Collection<PipelineExecutionSummary.BuilderImpl> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copyFromBuilder(pipelineExecutionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPipelineExecutionsResponse build() {
            return new ListPipelineExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
