/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateCustomActionType</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomActionTypeResponse extends CodePipelineResponse implements
        ToCopyableBuilder<CreateCustomActionTypeResponse.Builder, CreateCustomActionTypeResponse> {
    private static final SdkField<ActionType> ACTION_TYPE_FIELD = SdkField.<ActionType> builder(MarshallingType.SDK_POJO)
            .memberName("actionType").getter(getter(CreateCustomActionTypeResponse::actionType))
            .setter(setter(Builder::actionType)).constructor(ActionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCustomActionTypeResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, TAGS_FIELD));

    private final ActionType actionType;

    private final List<Tag> tags;

    private CreateCustomActionTypeResponse(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Returns information about the details of an action type.
     * </p>
     * 
     * @return Returns information about the details of an action type.
     */
    public final ActionType actionType() {
        return actionType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags applied to the custom action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the tags applied to the custom action.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomActionTypeResponse)) {
            return false;
        }
        CreateCustomActionTypeResponse other = (CreateCustomActionTypeResponse) obj;
        return Objects.equals(actionType(), other.actionType()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomActionTypeResponse").add("ActionType", actionType())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomActionTypeResponse, T> g) {
        return obj -> g.apply((CreateCustomActionTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomActionTypeResponse> {
        /**
         * <p>
         * Returns information about the details of an action type.
         * </p>
         * 
         * @param actionType
         *        Returns information about the details of an action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * Returns information about the details of an action type.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionType.Builder} avoiding the need to create
         * one manually via {@link ActionType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionType.Builder#build()} is called immediately and its result
         * is passed to {@link #actionType(ActionType)}.
         * 
         * @param actionType
         *        a consumer that will call methods on {@link ActionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionType(ActionType)
         */
        default Builder actionType(Consumer<ActionType.Builder> actionType) {
            return actionType(ActionType.builder().applyMutation(actionType).build());
        }

        /**
         * <p>
         * Specifies the tags applied to the custom action.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the tags applied to the custom action.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the tags applied to the custom action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private ActionType actionType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomActionTypeResponse model) {
            super(model);
            actionType(model.actionType);
            tags(model.tags);
        }

        public final ActionType.Builder getActionType() {
            return actionType != null ? actionType.toBuilder() : null;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public final void setActionType(ActionType.BuilderImpl actionType) {
            this.actionType = actionType != null ? actionType.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CreateCustomActionTypeResponse build() {
            return new CreateCustomActionTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
