/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the settings for an action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionTypeSettings.Builder, ActionTypeSettings> {
    private static final SdkField<String> THIRD_PARTY_CONFIGURATION_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("thirdPartyConfigurationUrl")
            .getter(getter(ActionTypeSettings::thirdPartyConfigurationUrl))
            .setter(setter(Builder::thirdPartyConfigurationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thirdPartyConfigurationUrl").build())
            .build();

    private static final SdkField<String> ENTITY_URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityUrlTemplate").getter(getter(ActionTypeSettings::entityUrlTemplate))
            .setter(setter(Builder::entityUrlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityUrlTemplate").build()).build();

    private static final SdkField<String> EXECUTION_URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionUrlTemplate").getter(getter(ActionTypeSettings::executionUrlTemplate))
            .setter(setter(Builder::executionUrlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionUrlTemplate").build())
            .build();

    private static final SdkField<String> REVISION_URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionUrlTemplate").getter(getter(ActionTypeSettings::revisionUrlTemplate))
            .setter(setter(Builder::revisionUrlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrlTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            THIRD_PARTY_CONFIGURATION_URL_FIELD, ENTITY_URL_TEMPLATE_FIELD, EXECUTION_URL_TEMPLATE_FIELD,
            REVISION_URL_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thirdPartyConfigurationUrl;

    private final String entityUrlTemplate;

    private final String executionUrlTemplate;

    private final String revisionUrlTemplate;

    private ActionTypeSettings(BuilderImpl builder) {
        this.thirdPartyConfigurationUrl = builder.thirdPartyConfigurationUrl;
        this.entityUrlTemplate = builder.entityUrlTemplate;
        this.executionUrlTemplate = builder.executionUrlTemplate;
        this.revisionUrlTemplate = builder.revisionUrlTemplate;
    }

    /**
     * <p>
     * The URL of a sign-up page where users can sign up for an external service and perform initial configuration of
     * the action provided by that service.
     * </p>
     * 
     * @return The URL of a sign-up page where users can sign up for an external service and perform initial
     *         configuration of the action provided by that service.
     */
    public final String thirdPartyConfigurationUrl() {
        return thirdPartyConfigurationUrl;
    }

    /**
     * <p>
     * The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external
     * system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of
     * the action display in the pipeline.
     * </p>
     * 
     * @return The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the
     *         external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is
     *         provided as part of the action display in the pipeline.
     */
    public final String entityUrlTemplate() {
        return entityUrlTemplate;
    }

    /**
     * <p>
     * The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the
     * external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the
     * AWS CodePipeline console and provides a link to the execution entity of the external action.
     * </p>
     * 
     * @return The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for
     *         the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view
     *         page in the AWS CodePipeline console and provides a link to the execution entity of the external action.
     */
    public final String executionUrlTemplate() {
        return executionUrlTemplate;
    }

    /**
     * <p>
     * The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or
     * change the configuration of the external action.
     * </p>
     * 
     * @return The URL returned to the AWS CodePipeline console that contains a link to the page where customers can
     *         update or change the configuration of the external action.
     */
    public final String revisionUrlTemplate() {
        return revisionUrlTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thirdPartyConfigurationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(entityUrlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(executionUrlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(revisionUrlTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeSettings)) {
            return false;
        }
        ActionTypeSettings other = (ActionTypeSettings) obj;
        return Objects.equals(thirdPartyConfigurationUrl(), other.thirdPartyConfigurationUrl())
                && Objects.equals(entityUrlTemplate(), other.entityUrlTemplate())
                && Objects.equals(executionUrlTemplate(), other.executionUrlTemplate())
                && Objects.equals(revisionUrlTemplate(), other.revisionUrlTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeSettings").add("ThirdPartyConfigurationUrl", thirdPartyConfigurationUrl())
                .add("EntityUrlTemplate", entityUrlTemplate()).add("ExecutionUrlTemplate", executionUrlTemplate())
                .add("RevisionUrlTemplate", revisionUrlTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thirdPartyConfigurationUrl":
            return Optional.ofNullable(clazz.cast(thirdPartyConfigurationUrl()));
        case "entityUrlTemplate":
            return Optional.ofNullable(clazz.cast(entityUrlTemplate()));
        case "executionUrlTemplate":
            return Optional.ofNullable(clazz.cast(executionUrlTemplate()));
        case "revisionUrlTemplate":
            return Optional.ofNullable(clazz.cast(revisionUrlTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeSettings, T> g) {
        return obj -> g.apply((ActionTypeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeSettings> {
        /**
         * <p>
         * The URL of a sign-up page where users can sign up for an external service and perform initial configuration
         * of the action provided by that service.
         * </p>
         * 
         * @param thirdPartyConfigurationUrl
         *        The URL of a sign-up page where users can sign up for an external service and perform initial
         *        configuration of the action provided by that service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thirdPartyConfigurationUrl(String thirdPartyConfigurationUrl);

        /**
         * <p>
         * The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external
         * system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part
         * of the action display in the pipeline.
         * </p>
         * 
         * @param entityUrlTemplate
         *        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the
         *        external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is
         *        provided as part of the action display in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityUrlTemplate(String entityUrlTemplate);

        /**
         * <p>
         * The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the
         * external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in
         * the AWS CodePipeline console and provides a link to the execution entity of the external action.
         * </p>
         * 
         * @param executionUrlTemplate
         *        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page
         *        for the external system, such as the console page for AWS CodeDeploy. This link is shown on the
         *        pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the
         *        external action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionUrlTemplate(String executionUrlTemplate);

        /**
         * <p>
         * The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update
         * or change the configuration of the external action.
         * </p>
         * 
         * @param revisionUrlTemplate
         *        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can
         *        update or change the configuration of the external action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionUrlTemplate(String revisionUrlTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String thirdPartyConfigurationUrl;

        private String entityUrlTemplate;

        private String executionUrlTemplate;

        private String revisionUrlTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeSettings model) {
            thirdPartyConfigurationUrl(model.thirdPartyConfigurationUrl);
            entityUrlTemplate(model.entityUrlTemplate);
            executionUrlTemplate(model.executionUrlTemplate);
            revisionUrlTemplate(model.revisionUrlTemplate);
        }

        public final String getThirdPartyConfigurationUrl() {
            return thirdPartyConfigurationUrl;
        }

        @Override
        public final Builder thirdPartyConfigurationUrl(String thirdPartyConfigurationUrl) {
            this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
            return this;
        }

        public final void setThirdPartyConfigurationUrl(String thirdPartyConfigurationUrl) {
            this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
        }

        public final String getEntityUrlTemplate() {
            return entityUrlTemplate;
        }

        @Override
        public final Builder entityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
            return this;
        }

        public final void setEntityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
        }

        public final String getExecutionUrlTemplate() {
            return executionUrlTemplate;
        }

        @Override
        public final Builder executionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
            return this;
        }

        public final void setExecutionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
        }

        public final String getRevisionUrlTemplate() {
            return revisionUrlTemplate;
        }

        @Override
        public final Builder revisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
            return this;
        }

        public final void setRevisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
        }

        @Override
        public ActionTypeSettings build() {
            return new ActionTypeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
