/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the run of an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecution implements SdkPojo, Serializable, ToCopyableBuilder<ActionExecution.Builder, ActionExecution> {
    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionExecutionId").getter(getter(ActionExecution::actionExecutionId))
            .setter(setter(Builder::actionExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ActionExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("summary")
            .getter(getter(ActionExecution::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatusChange").getter(getter(ActionExecution::lastStatusChange))
            .setter(setter(Builder::lastStatusChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChange").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(ActionExecution::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(ActionExecution::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionId").getter(getter(ActionExecution::externalExecutionId))
            .setter(setter(Builder::externalExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build())
            .build();

    private static final SdkField<String> EXTERNAL_EXECUTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionUrl").getter(getter(ActionExecution::externalExecutionUrl))
            .setter(setter(Builder::externalExecutionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionUrl").build())
            .build();

    private static final SdkField<Integer> PERCENT_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("percentComplete").getter(getter(ActionExecution::percentComplete))
            .setter(setter(Builder::percentComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentComplete").build()).build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("errorDetails").getter(getter(ActionExecution::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_EXECUTION_ID_FIELD,
            STATUS_FIELD, SUMMARY_FIELD, LAST_STATUS_CHANGE_FIELD, TOKEN_FIELD, LAST_UPDATED_BY_FIELD,
            EXTERNAL_EXECUTION_ID_FIELD, EXTERNAL_EXECUTION_URL_FIELD, PERCENT_COMPLETE_FIELD, ERROR_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionExecutionId;

    private final String status;

    private final String summary;

    private final Instant lastStatusChange;

    private final String token;

    private final String lastUpdatedBy;

    private final String externalExecutionId;

    private final String externalExecutionUrl;

    private final Integer percentComplete;

    private final ErrorDetails errorDetails;

    private ActionExecution(BuilderImpl builder) {
        this.actionExecutionId = builder.actionExecutionId;
        this.status = builder.status;
        this.summary = builder.summary;
        this.lastStatusChange = builder.lastStatusChange;
        this.token = builder.token;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionUrl = builder.externalExecutionUrl;
        this.percentComplete = builder.percentComplete;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * ID of the workflow action execution in the current stage. Use the <a>GetPipelineState</a> action to retrieve the
     * current action execution details of the current stage.
     * </p>
     * <note>
     * <p>
     * For older executions, this field might be empty. The action execution ID is available for executions run on or
     * after March 2020.
     * </p>
     * </note>
     * 
     * @return ID of the workflow action execution in the current stage. Use the <a>GetPipelineState</a> action to
     *         retrieve the current action execution details of the current stage.</p> <note>
     *         <p>
     *         For older executions, this field might be empty. The action execution ID is available for executions run
     *         on or after March 2020.
     *         </p>
     */
    public final String actionExecutionId() {
        return actionExecutionId;
    }

    /**
     * <p>
     * The status of the action, or for a completed action, the last status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action, or for a completed action, the last status of the action.
     * @see ActionExecutionStatus
     */
    public final ActionExecutionStatus status() {
        return ActionExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action, or for a completed action, the last status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action, or for a completed action, the last status of the action.
     * @see ActionExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A summary of the run of the action.
     * </p>
     * 
     * @return A summary of the run of the action.
     */
    public final String summary() {
        return summary;
    }

    /**
     * <p>
     * The last status change of the action.
     * </p>
     * 
     * @return The last status change of the action.
     */
    public final Instant lastStatusChange() {
        return lastStatusChange;
    }

    /**
     * <p>
     * The system-generated token used to identify a unique approval request. The token for each open approval request
     * can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the approval request
     * corresponding to this token is still valid.
     * </p>
     * 
     * @return The system-generated token used to identify a unique approval request. The token for each open approval
     *         request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the
     *         approval request corresponding to this token is still valid.
     */
    public final String token() {
        return token;
    }

    /**
     * <p>
     * The ARN of the user who last changed the pipeline.
     * </p>
     * 
     * @return The ARN of the user who last changed the pipeline.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The external ID of the run of the action.
     * </p>
     * 
     * @return The external ID of the run of the action.
     */
    public final String externalExecutionId() {
        return externalExecutionId;
    }

    /**
     * <p>
     * The URL of a resource external to AWS that is used when running the action (for example, an external repository
     * URL).
     * </p>
     * 
     * @return The URL of a resource external to AWS that is used when running the action (for example, an external
     *         repository URL).
     */
    public final String externalExecutionUrl() {
        return externalExecutionUrl;
    }

    /**
     * <p>
     * A percentage of completeness of the action as it runs.
     * </p>
     * 
     * @return A percentage of completeness of the action as it runs.
     */
    public final Integer percentComplete() {
        return percentComplete;
    }

    /**
     * <p>
     * The details of an error returned by a URL external to AWS.
     * </p>
     * 
     * @return The details of an error returned by a URL external to AWS.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(percentComplete());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecution)) {
            return false;
        }
        ActionExecution other = (ActionExecution) obj;
        return Objects.equals(actionExecutionId(), other.actionExecutionId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(summary(), other.summary())
                && Objects.equals(lastStatusChange(), other.lastStatusChange()) && Objects.equals(token(), other.token())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && Objects.equals(externalExecutionId(), other.externalExecutionId())
                && Objects.equals(externalExecutionUrl(), other.externalExecutionUrl())
                && Objects.equals(percentComplete(), other.percentComplete())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionExecution").add("ActionExecutionId", actionExecutionId()).add("Status", statusAsString())
                .add("Summary", summary()).add("LastStatusChange", lastStatusChange()).add("Token", token())
                .add("LastUpdatedBy", lastUpdatedBy()).add("ExternalExecutionId", externalExecutionId())
                .add("ExternalExecutionUrl", externalExecutionUrl()).add("PercentComplete", percentComplete())
                .add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionExecutionId":
            return Optional.ofNullable(clazz.cast(actionExecutionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "lastStatusChange":
            return Optional.ofNullable(clazz.cast(lastStatusChange()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "externalExecutionId":
            return Optional.ofNullable(clazz.cast(externalExecutionId()));
        case "externalExecutionUrl":
            return Optional.ofNullable(clazz.cast(externalExecutionUrl()));
        case "percentComplete":
            return Optional.ofNullable(clazz.cast(percentComplete()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecution, T> g) {
        return obj -> g.apply((ActionExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecution> {
        /**
         * <p>
         * ID of the workflow action execution in the current stage. Use the <a>GetPipelineState</a> action to retrieve
         * the current action execution details of the current stage.
         * </p>
         * <note>
         * <p>
         * For older executions, this field might be empty. The action execution ID is available for executions run on
         * or after March 2020.
         * </p>
         * </note>
         * 
         * @param actionExecutionId
         *        ID of the workflow action execution in the current stage. Use the <a>GetPipelineState</a> action to
         *        retrieve the current action execution details of the current stage.</p> <note>
         *        <p>
         *        For older executions, this field might be empty. The action execution ID is available for executions
         *        run on or after March 2020.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecutionId(String actionExecutionId);

        /**
         * <p>
         * The status of the action, or for a completed action, the last status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action, or for a completed action, the last status of the action.
         * @see ActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action, or for a completed action, the last status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action, or for a completed action, the last status of the action.
         * @see ActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionExecutionStatus
         */
        Builder status(ActionExecutionStatus status);

        /**
         * <p>
         * A summary of the run of the action.
         * </p>
         * 
         * @param summary
         *        A summary of the run of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);

        /**
         * <p>
         * The last status change of the action.
         * </p>
         * 
         * @param lastStatusChange
         *        The last status change of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(Instant lastStatusChange);

        /**
         * <p>
         * The system-generated token used to identify a unique approval request. The token for each open approval
         * request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the
         * approval request corresponding to this token is still valid.
         * </p>
         * 
         * @param token
         *        The system-generated token used to identify a unique approval request. The token for each open
         *        approval request can be obtained using the <code>GetPipelineState</code> command. It is used to
         *        validate that the approval request corresponding to this token is still valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The ARN of the user who last changed the pipeline.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The ARN of the user who last changed the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The external ID of the run of the action.
         * </p>
         * 
         * @param externalExecutionId
         *        The external ID of the run of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionId(String externalExecutionId);

        /**
         * <p>
         * The URL of a resource external to AWS that is used when running the action (for example, an external
         * repository URL).
         * </p>
         * 
         * @param externalExecutionUrl
         *        The URL of a resource external to AWS that is used when running the action (for example, an external
         *        repository URL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionUrl(String externalExecutionUrl);

        /**
         * <p>
         * A percentage of completeness of the action as it runs.
         * </p>
         * 
         * @param percentComplete
         *        A percentage of completeness of the action as it runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentComplete(Integer percentComplete);

        /**
         * <p>
         * The details of an error returned by a URL external to AWS.
         * </p>
         * 
         * @param errorDetails
         *        The details of an error returned by a URL external to AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * <p>
         * The details of an error returned by a URL external to AWS.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorDetails.Builder} avoiding the need to
         * create one manually via {@link ErrorDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionExecutionId;

        private String status;

        private String summary;

        private Instant lastStatusChange;

        private String token;

        private String lastUpdatedBy;

        private String externalExecutionId;

        private String externalExecutionUrl;

        private Integer percentComplete;

        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecution model) {
            actionExecutionId(model.actionExecutionId);
            status(model.status);
            summary(model.summary);
            lastStatusChange(model.lastStatusChange);
            token(model.token);
            lastUpdatedBy(model.lastUpdatedBy);
            externalExecutionId(model.externalExecutionId);
            externalExecutionUrl(model.externalExecutionUrl);
            percentComplete(model.percentComplete);
            errorDetails(model.errorDetails);
        }

        public final String getActionExecutionId() {
            return actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSummary() {
            return summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final Instant getLastStatusChange() {
            return lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getExternalExecutionId() {
            return externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public final String getExternalExecutionUrl() {
            return externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        public final Integer getPercentComplete() {
            return percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public ActionExecution build() {
            return new ActionExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
