/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdatePipeline</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineResponse extends CodePipelineResponse implements
        ToCopyableBuilder<UpdatePipelineResponse.Builder, UpdatePipelineResponse> {
    private static final SdkField<PipelineDeclaration> PIPELINE_FIELD = SdkField
            .<PipelineDeclaration> builder(MarshallingType.SDK_POJO).getter(getter(UpdatePipelineResponse::pipeline))
            .setter(setter(Builder::pipeline)).constructor(PipelineDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD));

    private final PipelineDeclaration pipeline;

    private UpdatePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
    }

    /**
     * <p>
     * The structure of the updated pipeline.
     * </p>
     * 
     * @return The structure of the updated pipeline.
     */
    public PipelineDeclaration pipeline() {
        return pipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineResponse)) {
            return false;
        }
        UpdatePipelineResponse other = (UpdatePipelineResponse) obj;
        return Objects.equals(pipeline(), other.pipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePipelineResponse").add("Pipeline", pipeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineResponse, T> g) {
        return obj -> g.apply((UpdatePipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineResponse> {
        /**
         * <p>
         * The structure of the updated pipeline.
         * </p>
         * 
         * @param pipeline
         *        The structure of the updated pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(PipelineDeclaration pipeline);

        /**
         * <p>
         * The structure of the updated pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link PipelineDeclaration.Builder} avoiding the need
         * to create one manually via {@link PipelineDeclaration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineDeclaration.Builder#build()} is called immediately and
         * its result is passed to {@link #pipeline(PipelineDeclaration)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link PipelineDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(PipelineDeclaration)
         */
        default Builder pipeline(Consumer<PipelineDeclaration.Builder> pipeline) {
            return pipeline(PipelineDeclaration.builder().applyMutation(pipeline).build());
        }
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private PipelineDeclaration pipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineResponse model) {
            super(model);
            pipeline(model.pipeline);
        }

        public final PipelineDeclaration.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        @Override
        public final Builder pipeline(PipelineDeclaration pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final void setPipeline(PipelineDeclaration.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public UpdatePipelineResponse build() {
            return new UpdatePipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
