/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a stage and its definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<StageDeclaration.Builder, StageDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StageDeclaration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<BlockerDeclaration>> BLOCKERS_FIELD = SdkField
            .<List<BlockerDeclaration>> builder(MarshallingType.LIST)
            .getter(getter(StageDeclaration::blockers))
            .setter(setter(Builder::blockers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockerDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockerDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ActionDeclaration>> ACTIONS_FIELD = SdkField
            .<List<ActionDeclaration>> builder(MarshallingType.LIST)
            .getter(getter(StageDeclaration::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BLOCKERS_FIELD,
            ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<BlockerDeclaration> blockers;

    private final List<ActionDeclaration> actions;

    private StageDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.blockers = builder.blockers;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Blockers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBlockers() {
        return blockers != null && !(blockers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public List<BlockerDeclaration> blockers() {
        return blockers;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions included in a stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions included in a stage.
     */
    public List<ActionDeclaration> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(blockers());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeclaration)) {
            return false;
        }
        StageDeclaration other = (StageDeclaration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(blockers(), other.blockers())
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StageDeclaration").add("Name", name()).add("Blockers", blockers()).add("Actions", actions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "blockers":
            return Optional.ofNullable(clazz.cast(blockers()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageDeclaration, T> g) {
        return obj -> g.apply((StageDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageDeclaration> {
        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param name
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param blockers
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockers(Collection<BlockerDeclaration> blockers);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param blockers
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockers(BlockerDeclaration... blockers);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockerDeclaration>.Builder} avoiding the
         * need to create one manually via {@link List<BlockerDeclaration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockerDeclaration>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockers(List<BlockerDeclaration>)}.
         * 
         * @param blockers
         *        a consumer that will call methods on {@link List<BlockerDeclaration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockers(List<BlockerDeclaration>)
         */
        Builder blockers(Consumer<BlockerDeclaration.Builder>... blockers);

        /**
         * <p>
         * The actions included in a stage.
         * </p>
         * 
         * @param actions
         *        The actions included in a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<ActionDeclaration> actions);

        /**
         * <p>
         * The actions included in a stage.
         * </p>
         * 
         * @param actions
         *        The actions included in a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(ActionDeclaration... actions);

        /**
         * <p>
         * The actions included in a stage.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActionDeclaration>.Builder} avoiding the
         * need to create one manually via {@link List<ActionDeclaration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActionDeclaration>.Builder#build()} is called immediately
         * and its result is passed to {@link #actions(List<ActionDeclaration>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<ActionDeclaration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<ActionDeclaration>)
         */
        Builder actions(Consumer<ActionDeclaration.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<BlockerDeclaration> blockers = DefaultSdkAutoConstructList.getInstance();

        private List<ActionDeclaration> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeclaration model) {
            name(model.name);
            blockers(model.blockers);
            actions(model.actions);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<BlockerDeclaration.Builder> getBlockers() {
            return blockers != null ? blockers.stream().map(BlockerDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockers(Collection<BlockerDeclaration> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copy(blockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(BlockerDeclaration... blockers) {
            blockers(Arrays.asList(blockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(Consumer<BlockerDeclaration.Builder>... blockers) {
            blockers(Stream.of(blockers).map(c -> BlockerDeclaration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockers(Collection<BlockerDeclaration.BuilderImpl> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copyFromBuilder(blockers);
        }

        public final Collection<ActionDeclaration.Builder> getActions() {
            return actions != null ? actions.stream().map(ActionDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<ActionDeclaration> actions) {
            this.actions = StageActionDeclarationListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionDeclaration... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ActionDeclaration.Builder>... actions) {
            actions(Stream.of(actions).map(c -> ActionDeclaration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<ActionDeclaration.BuilderImpl> actions) {
            this.actions = StageActionDeclarationListCopier.copyFromBuilder(actions);
        }

        @Override
        public StageDeclaration build() {
            return new StageDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
