/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetJobDetails</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobDetailsResponse extends CodePipelineResponse implements
        ToCopyableBuilder<GetJobDetailsResponse.Builder, GetJobDetailsResponse> {
    private static final SdkField<JobDetails> JOB_DETAILS_FIELD = SdkField.<JobDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetJobDetailsResponse::jobDetails)).setter(setter(Builder::jobDetails))
            .constructor(JobDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD));

    private final JobDetails jobDetails;

    private GetJobDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDetails = builder.jobDetails;
    }

    /**
     * <p>
     * The details of the job.
     * </p>
     * <note>
     * <p>
     * If AWSSessionCredentials is used, a long-running job can call <code>GetJobDetails</code> again to obtain new
     * credentials.
     * </p>
     * </note>
     * 
     * @return The details of the job.</p> <note>
     *         <p>
     *         If AWSSessionCredentials is used, a long-running job can call <code>GetJobDetails</code> again to obtain
     *         new credentials.
     *         </p>
     */
    public JobDetails jobDetails() {
        return jobDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobDetailsResponse)) {
            return false;
        }
        GetJobDetailsResponse other = (GetJobDetailsResponse) obj;
        return Objects.equals(jobDetails(), other.jobDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetJobDetailsResponse").add("JobDetails", jobDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobDetailsResponse, T> g) {
        return obj -> g.apply((GetJobDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobDetailsResponse> {
        /**
         * <p>
         * The details of the job.
         * </p>
         * <note>
         * <p>
         * If AWSSessionCredentials is used, a long-running job can call <code>GetJobDetails</code> again to obtain new
         * credentials.
         * </p>
         * </note>
         * 
         * @param jobDetails
         *        The details of the job.</p> <note>
         *        <p>
         *        If AWSSessionCredentials is used, a long-running job can call <code>GetJobDetails</code> again to
         *        obtain new credentials.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(JobDetails jobDetails);

        /**
         * <p>
         * The details of the job.
         * </p>
         * <note>
         * <p>
         * If AWSSessionCredentials is used, a long-running job can call <code>GetJobDetails</code> again to obtain new
         * credentials.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link JobDetails.Builder} avoiding the need to
         * create one manually via {@link JobDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #jobDetails(JobDetails)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link JobDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(JobDetails)
         */
        default Builder jobDetails(Consumer<JobDetails.Builder> jobDetails) {
            return jobDetails(JobDetails.builder().applyMutation(jobDetails).build());
        }
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private JobDetails jobDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobDetailsResponse model) {
            super(model);
            jobDetails(model.jobDetails);
        }

        public final JobDetails.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        @Override
        public final Builder jobDetails(JobDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        public final void setJobDetails(JobDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        @Override
        public GetJobDetailsResponse build() {
            return new GetJobDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
