/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an execution of an action, including the action execution ID, and the name, version, and
 * timing of the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionDetail.Builder, ActionExecutionDetail> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionDetail::pipelineExecutionId)).setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionDetail::actionExecutionId)).setter(setter(Builder::actionExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()).build();

    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ActionExecutionDetail::pipelineVersion)).setter(setter(Builder::pipelineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionDetail::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionDetail::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ActionExecutionDetail::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ActionExecutionDetail::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ActionExecutionInput> INPUT_FIELD = SdkField
            .<ActionExecutionInput> builder(MarshallingType.SDK_POJO).getter(getter(ActionExecutionDetail::input))
            .setter(setter(Builder::input)).constructor(ActionExecutionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<ActionExecutionOutput> OUTPUT_FIELD = SdkField
            .<ActionExecutionOutput> builder(MarshallingType.SDK_POJO).getter(getter(ActionExecutionDetail::output))
            .setter(setter(Builder::output)).constructor(ActionExecutionOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD,
            ACTION_EXECUTION_ID_FIELD, PIPELINE_VERSION_FIELD, STAGE_NAME_FIELD, ACTION_NAME_FIELD, START_TIME_FIELD,
            LAST_UPDATE_TIME_FIELD, STATUS_FIELD, INPUT_FIELD, OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineExecutionId;

    private final String actionExecutionId;

    private final Integer pipelineVersion;

    private final String stageName;

    private final String actionName;

    private final Instant startTime;

    private final Instant lastUpdateTime;

    private final String status;

    private final ActionExecutionInput input;

    private final ActionExecutionOutput output;

    private ActionExecutionDetail(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.actionExecutionId = builder.actionExecutionId;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.input = builder.input;
        this.output = builder.output;
    }

    /**
     * <p>
     * The pipeline execution ID for the action execution.
     * </p>
     * 
     * @return The pipeline execution ID for the action execution.
     */
    public String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The action execution ID.
     * </p>
     * 
     * @return The action execution ID.
     */
    public String actionExecutionId() {
        return actionExecutionId;
    }

    /**
     * <p>
     * The version of the pipeline where the action was run.
     * </p>
     * 
     * @return The version of the pipeline where the action was run.
     */
    public Integer pipelineVersion() {
        return pipelineVersion;
    }

    /**
     * <p>
     * The name of the stage that contains the action.
     * </p>
     * 
     * @return The name of the stage that contains the action.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * 
     * @return The name of the action.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The start time of the action execution.
     * </p>
     * 
     * @return The start time of the action execution.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The last update time of the action execution.
     * </p>
     * 
     * @return The last update time of the action execution.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>
     *         , and <code>Failed</code>.
     * @see ActionExecutionStatus
     */
    public ActionExecutionStatus status() {
        return ActionExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>
     *         , and <code>Failed</code>.
     * @see ActionExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Input details for the action execution, such as role ARN, Region, and input artifacts.
     * </p>
     * 
     * @return Input details for the action execution, such as role ARN, Region, and input artifacts.
     */
    public ActionExecutionInput input() {
        return input;
    }

    /**
     * <p>
     * Output details for the action execution, such as the action execution result.
     * </p>
     * 
     * @return Output details for the action execution, such as the action execution result.
     */
    public ActionExecutionOutput output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionDetail)) {
            return false;
        }
        ActionExecutionDetail other = (ActionExecutionDetail) obj;
        return Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(actionExecutionId(), other.actionExecutionId())
                && Objects.equals(pipelineVersion(), other.pipelineVersion()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(input(), other.input())
                && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActionExecutionDetail").add("PipelineExecutionId", pipelineExecutionId())
                .add("ActionExecutionId", actionExecutionId()).add("PipelineVersion", pipelineVersion())
                .add("StageName", stageName()).add("ActionName", actionName()).add("StartTime", startTime())
                .add("LastUpdateTime", lastUpdateTime()).add("Status", statusAsString()).add("Input", input())
                .add("Output", output()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "actionExecutionId":
            return Optional.ofNullable(clazz.cast(actionExecutionId()));
        case "pipelineVersion":
            return Optional.ofNullable(clazz.cast(pipelineVersion()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionDetail, T> g) {
        return obj -> g.apply((ActionExecutionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionDetail> {
        /**
         * <p>
         * The pipeline execution ID for the action execution.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The pipeline execution ID for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The action execution ID.
         * </p>
         * 
         * @param actionExecutionId
         *        The action execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecutionId(String actionExecutionId);

        /**
         * <p>
         * The version of the pipeline where the action was run.
         * </p>
         * 
         * @param pipelineVersion
         *        The version of the pipeline where the action was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersion(Integer pipelineVersion);

        /**
         * <p>
         * The name of the stage that contains the action.
         * </p>
         * 
         * @param stageName
         *        The name of the stage that contains the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param actionName
         *        The name of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The start time of the action execution.
         * </p>
         * 
         * @param startTime
         *        The start time of the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The last update time of the action execution.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>,
         * and <code>Failed</code>.
         * </p>
         * 
         * @param status
         *        The status of the action execution. Status categories are <code>InProgress</code>,
         *        <code>Succeeded</code>, and <code>Failed</code>.
         * @see ActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>,
         * and <code>Failed</code>.
         * </p>
         * 
         * @param status
         *        The status of the action execution. Status categories are <code>InProgress</code>,
         *        <code>Succeeded</code>, and <code>Failed</code>.
         * @see ActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionExecutionStatus
         */
        Builder status(ActionExecutionStatus status);

        /**
         * <p>
         * Input details for the action execution, such as role ARN, Region, and input artifacts.
         * </p>
         * 
         * @param input
         *        Input details for the action execution, such as role ARN, Region, and input artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(ActionExecutionInput input);

        /**
         * <p>
         * Input details for the action execution, such as role ARN, Region, and input artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionExecutionInput.Builder} avoiding the need
         * to create one manually via {@link ActionExecutionInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionExecutionInput.Builder#build()} is called immediately and
         * its result is passed to {@link #input(ActionExecutionInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link ActionExecutionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(ActionExecutionInput)
         */
        default Builder input(Consumer<ActionExecutionInput.Builder> input) {
            return input(ActionExecutionInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Output details for the action execution, such as the action execution result.
         * </p>
         * 
         * @param output
         *        Output details for the action execution, such as the action execution result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(ActionExecutionOutput output);

        /**
         * <p>
         * Output details for the action execution, such as the action execution result.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionExecutionOutput.Builder} avoiding the need
         * to create one manually via {@link ActionExecutionOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionExecutionOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(ActionExecutionOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link ActionExecutionOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(ActionExecutionOutput)
         */
        default Builder output(Consumer<ActionExecutionOutput.Builder> output) {
            return output(ActionExecutionOutput.builder().applyMutation(output).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String pipelineExecutionId;

        private String actionExecutionId;

        private Integer pipelineVersion;

        private String stageName;

        private String actionName;

        private Instant startTime;

        private Instant lastUpdateTime;

        private String status;

        private ActionExecutionInput input;

        private ActionExecutionOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionDetail model) {
            pipelineExecutionId(model.pipelineExecutionId);
            actionExecutionId(model.actionExecutionId);
            pipelineVersion(model.pipelineVersion);
            stageName(model.stageName);
            actionName(model.actionName);
            startTime(model.startTime);
            lastUpdateTime(model.lastUpdateTime);
            status(model.status);
            input(model.input);
            output(model.output);
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getActionExecutionId() {
            return actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        public final Integer getPipelineVersion() {
            return pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ActionExecutionInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(ActionExecutionInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(ActionExecutionInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final ActionExecutionOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(ActionExecutionOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(ActionExecutionOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public ActionExecutionDetail build() {
            return new ActionExecutionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
