/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the version (or revision) of a source artifact that initiated a pipeline execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceRevision implements SdkPojo, Serializable, ToCopyableBuilder<SourceRevision.Builder, SourceRevision> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceRevision::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceRevision::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> REVISION_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceRevision::revisionSummary)).setter(setter(Builder::revisionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionSummary").build()).build();

    private static final SdkField<String> REVISION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceRevision::revisionUrl)).setter(setter(Builder::revisionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            REVISION_ID_FIELD, REVISION_SUMMARY_FIELD, REVISION_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final String revisionId;

    private final String revisionSummary;

    private final String revisionUrl;

    private SourceRevision(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.revisionId = builder.revisionId;
        this.revisionSummary = builder.revisionSummary;
        this.revisionUrl = builder.revisionUrl;
    }

    /**
     * <p>
     * The name of the action that processed the revision to the source artifact.
     * </p>
     * 
     * @return The name of the action that processed the revision to the source artifact.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The system-generated unique ID that identifies the revision number of the artifact.
     * </p>
     * 
     * @return The system-generated unique ID that identifies the revision number of the artifact.
     */
    public String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories,
     * the commit message. For Amazon S3 buckets or actions, the user-provided content of a
     * <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
     * </p>
     * 
     * @return Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit
     *         repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a
     *         <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
     */
    public String revisionSummary() {
        return revisionSummary;
    }

    /**
     * <p>
     * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the
     * commit ID is linked to a commit details page.
     * </p>
     * 
     * @return The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories,
     *         the commit ID is linked to a commit details page.
     */
    public String revisionUrl() {
        return revisionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(revisionUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRevision)) {
            return false;
        }
        SourceRevision other = (SourceRevision) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(revisionSummary(), other.revisionSummary())
                && Objects.equals(revisionUrl(), other.revisionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceRevision").add("ActionName", actionName()).add("RevisionId", revisionId())
                .add("RevisionSummary", revisionSummary()).add("RevisionUrl", revisionUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "revisionSummary":
            return Optional.ofNullable(clazz.cast(revisionSummary()));
        case "revisionUrl":
            return Optional.ofNullable(clazz.cast(revisionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceRevision, T> g) {
        return obj -> g.apply((SourceRevision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceRevision> {
        /**
         * <p>
         * The name of the action that processed the revision to the source artifact.
         * </p>
         * 
         * @param actionName
         *        The name of the action that processed the revision to the source artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The system-generated unique ID that identifies the revision number of the artifact.
         * </p>
         * 
         * @param revisionId
         *        The system-generated unique ID that identifies the revision number of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit
         * repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a
         * <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
         * </p>
         * 
         * @param revisionSummary
         *        Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit
         *        repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a
         *        <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionSummary(String revisionSummary);

        /**
         * <p>
         * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the
         * commit ID is linked to a commit details page.
         * </p>
         * 
         * @param revisionUrl
         *        The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit
         *        repositories, the commit ID is linked to a commit details page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionUrl(String revisionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private String revisionId;

        private String revisionSummary;

        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRevision model) {
            actionName(model.actionName);
            revisionId(model.revisionId);
            revisionSummary(model.revisionSummary);
            revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionSummary() {
            return revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public final String getRevisionUrl() {
            return revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        public SourceRevision build() {
            return new SourceRevision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
