/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the structure of actions and stages to be performed in the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineDeclaration.Builder, PipelineDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineDeclaration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineDeclaration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ArtifactStore> ARTIFACT_STORE_FIELD = SdkField
            .<ArtifactStore> builder(MarshallingType.SDK_POJO).getter(getter(PipelineDeclaration::artifactStore))
            .setter(setter(Builder::artifactStore)).constructor(ArtifactStore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStore").build()).build();

    private static final SdkField<Map<String, ArtifactStore>> ARTIFACT_STORES_FIELD = SdkField
            .<Map<String, ArtifactStore>> builder(MarshallingType.MAP)
            .getter(getter(PipelineDeclaration::artifactStores))
            .setter(setter(Builder::artifactStores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStores").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ArtifactStore> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArtifactStore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<StageDeclaration>> STAGES_FIELD = SdkField
            .<List<StageDeclaration>> builder(MarshallingType.LIST)
            .getter(getter(PipelineDeclaration::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PipelineDeclaration::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            ARTIFACT_STORE_FIELD, ARTIFACT_STORES_FIELD, STAGES_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String roleArn;

    private final ArtifactStore artifactStore;

    private final Map<String, ArtifactStore> artifactStores;

    private final List<StageDeclaration> stages;

    private final Integer version;

    private PipelineDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.artifactStore = builder.artifactStore;
        this.artifactStores = builder.artifactStores;
        this.stages = builder.stages;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the action to be performed.
     * </p>
     * 
     * @return The name of the action to be performed.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no
     * <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no
     *         <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Represents information about the S3 bucket where artifacts are stored for the pipeline.
     * </p>
     * <note>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
     * cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.
     * </p>
     * </note>
     * 
     * @return Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
     *         <p>
     *         You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but
     *         you cannot use both. If you create a cross-region action in your pipeline, you must use
     *         <code>artifactStores</code>.
     *         </p>
     */
    public ArtifactStore artifactStore() {
        return artifactStore;
    }

    /**
     * Returns true if the ArtifactStores property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArtifactStores() {
        return artifactStores != null && !(artifactStores instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an artifact
     * store for the pipeline Region and for each cross-region action in the pipeline.
     * </p>
     * <note>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
     * cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArtifactStores()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an
     *         artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note>
     *         <p>
     *         You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but
     *         you cannot use both. If you create a cross-region action in your pipeline, you must use
     *         <code>artifactStores</code>.
     *         </p>
     */
    public Map<String, ArtifactStore> artifactStores() {
        return artifactStores;
    }

    /**
     * Returns true if the Stages property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stage in which to perform the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stage in which to perform the action.
     */
    public List<StageDeclaration> stages() {
        return stages;
    }

    /**
     * <p>
     * The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented
     * when a pipeline is updated.
     * </p>
     * 
     * @return The version number of the pipeline. A new pipeline always has a version number of 1. This number is
     *         incremented when a pipeline is updated.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(artifactStore());
        hashCode = 31 * hashCode + Objects.hashCode(artifactStores());
        hashCode = 31 * hashCode + Objects.hashCode(stages());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(artifactStore(), other.artifactStore())
                && Objects.equals(artifactStores(), other.artifactStores()) && Objects.equals(stages(), other.stages())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PipelineDeclaration").add("Name", name()).add("RoleArn", roleArn())
                .add("ArtifactStore", artifactStore()).add("ArtifactStores", artifactStores()).add("Stages", stages())
                .add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "artifactStore":
            return Optional.ofNullable(clazz.cast(artifactStore()));
        case "artifactStores":
            return Optional.ofNullable(clazz.cast(artifactStores()));
        case "stages":
            return Optional.ofNullable(clazz.cast(stages()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDeclaration, T> g) {
        return obj -> g.apply((PipelineDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineDeclaration> {
        /**
         * <p>
         * The name of the action to be performed.
         * </p>
         * 
         * @param name
         *        The name of the action to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no
         * <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no
         *        <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         * </p>
         * <note>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
         * cannot use both. If you create a cross-region action in your pipeline, you must use
         * <code>artifactStores</code>.
         * </p>
         * </note>
         * 
         * @param artifactStore
         *        Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
         *        <p>
         *        You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline,
         *        but you cannot use both. If you create a cross-region action in your pipeline, you must use
         *        <code>artifactStores</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStore(ArtifactStore artifactStore);

        /**
         * <p>
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         * </p>
         * <note>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
         * cannot use both. If you create a cross-region action in your pipeline, you must use
         * <code>artifactStores</code>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ArtifactStore.Builder} avoiding the need
         * to create one manually via {@link ArtifactStore#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactStore.Builder#build()} is called immediately and its
         * result is passed to {@link #artifactStore(ArtifactStore)}.
         * 
         * @param artifactStore
         *        a consumer that will call methods on {@link ArtifactStore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactStore(ArtifactStore)
         */
        default Builder artifactStore(Consumer<ArtifactStore.Builder> artifactStore) {
            return artifactStore(ArtifactStore.builder().applyMutation(artifactStore).build());
        }

        /**
         * <p>
         * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an
         * artifact store for the pipeline Region and for each cross-region action in the pipeline.
         * </p>
         * <note>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
         * cannot use both. If you create a cross-region action in your pipeline, you must use
         * <code>artifactStores</code>.
         * </p>
         * </note>
         * 
         * @param artifactStores
         *        A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an
         *        artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note>
         *        <p>
         *        You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline,
         *        but you cannot use both. If you create a cross-region action in your pipeline, you must use
         *        <code>artifactStores</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStores(Map<String, ArtifactStore> artifactStores);

        /**
         * <p>
         * The stage in which to perform the action.
         * </p>
         * 
         * @param stages
         *        The stage in which to perform the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<StageDeclaration> stages);

        /**
         * <p>
         * The stage in which to perform the action.
         * </p>
         * 
         * @param stages
         *        The stage in which to perform the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(StageDeclaration... stages);

        /**
         * <p>
         * The stage in which to perform the action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StageDeclaration>.Builder} avoiding the
         * need to create one manually via {@link List<StageDeclaration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StageDeclaration>.Builder#build()} is called immediately and
         * its result is passed to {@link #stages(List<StageDeclaration>)}.
         * 
         * @param stages
         *        a consumer that will call methods on {@link List<StageDeclaration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stages(List<StageDeclaration>)
         */
        Builder stages(Consumer<StageDeclaration.Builder>... stages);

        /**
         * <p>
         * The version number of the pipeline. A new pipeline always has a version number of 1. This number is
         * incremented when a pipeline is updated.
         * </p>
         * 
         * @param version
         *        The version number of the pipeline. A new pipeline always has a version number of 1. This number is
         *        incremented when a pipeline is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String roleArn;

        private ArtifactStore artifactStore;

        private Map<String, ArtifactStore> artifactStores = DefaultSdkAutoConstructMap.getInstance();

        private List<StageDeclaration> stages = DefaultSdkAutoConstructList.getInstance();

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDeclaration model) {
            name(model.name);
            roleArn(model.roleArn);
            artifactStore(model.artifactStore);
            artifactStores(model.artifactStores);
            stages(model.stages);
            version(model.version);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final ArtifactStore.Builder getArtifactStore() {
            return artifactStore != null ? artifactStore.toBuilder() : null;
        }

        @Override
        public final Builder artifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        public final void setArtifactStore(ArtifactStore.BuilderImpl artifactStore) {
            this.artifactStore = artifactStore != null ? artifactStore.build() : null;
        }

        public final Map<String, ArtifactStore.Builder> getArtifactStores() {
            return artifactStores != null ? CollectionUtils.mapValues(artifactStores, ArtifactStore::toBuilder) : null;
        }

        @Override
        public final Builder artifactStores(Map<String, ArtifactStore> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copy(artifactStores);
            return this;
        }

        public final void setArtifactStores(Map<String, ArtifactStore.BuilderImpl> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copyFromBuilder(artifactStores);
        }

        public final Collection<StageDeclaration.Builder> getStages() {
            return stages != null ? stages.stream().map(StageDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageDeclaration... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<StageDeclaration.Builder>... stages) {
            stages(Stream.of(stages).map(c -> StageDeclaration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStages(Collection<StageDeclaration.BuilderImpl> stages) {
            this.stages = PipelineStageDeclarationListCopier.copyFromBuilder(stages);
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public PipelineDeclaration build() {
            return new PipelineDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
