/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListPipelines</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelinesResponse extends CodePipelineResponse implements
        ToCopyableBuilder<ListPipelinesResponse.Builder, ListPipelinesResponse> {
    private static final SdkField<List<PipelineSummary>> PIPELINES_FIELD = SdkField
            .<List<PipelineSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListPipelinesResponse::pipelines))
            .setter(setter(Builder::pipelines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPipelinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PipelineSummary> pipelines;

    private final String nextToken;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelines = builder.pipelines;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Pipelines property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPipelines() {
        return pipelines != null && !(pipelines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of pipelines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelines()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of pipelines.
     */
    public List<PipelineSummary> pipelines() {
        return pipelines;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an identifier is also returned. It can be used in a
     * subsequent list pipelines call to return the next set of pipelines in the list.
     * </p>
     * 
     * @return If the amount of returned information is significantly large, an identifier is also returned. It can be
     *         used in a subsequent list pipelines call to return the next set of pipelines in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelines());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse) obj;
        return Objects.equals(pipelines(), other.pipelines()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPipelinesResponse").add("Pipelines", pipelines()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelines":
            return Optional.ofNullable(clazz.cast(pipelines()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelinesResponse> {
        /**
         * <p>
         * The list of pipelines.
         * </p>
         * 
         * @param pipelines
         *        The list of pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(Collection<PipelineSummary> pipelines);

        /**
         * <p>
         * The list of pipelines.
         * </p>
         * 
         * @param pipelines
         *        The list of pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(PipelineSummary... pipelines);

        /**
         * <p>
         * The list of pipelines.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineSummary>.Builder} avoiding the need
         * to create one manually via {@link List<PipelineSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelines(List<PipelineSummary>)}.
         * 
         * @param pipelines
         *        a consumer that will call methods on {@link List<PipelineSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelines(List<PipelineSummary>)
         */
        Builder pipelines(Consumer<PipelineSummary.Builder>... pipelines);

        /**
         * <p>
         * If the amount of returned information is significantly large, an identifier is also returned. It can be used
         * in a subsequent list pipelines call to return the next set of pipelines in the list.
         * </p>
         * 
         * @param nextToken
         *        If the amount of returned information is significantly large, an identifier is also returned. It can
         *        be used in a subsequent list pipelines call to return the next set of pipelines in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<PipelineSummary> pipelines = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            pipelines(model.pipelines);
            nextToken(model.nextToken);
        }

        public final Collection<PipelineSummary.Builder> getPipelines() {
            return pipelines != null ? pipelines.stream().map(PipelineSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelines(Collection<PipelineSummary> pipelines) {
            this.pipelines = PipelineListCopier.copy(pipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(PipelineSummary... pipelines) {
            pipelines(Arrays.asList(pipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Consumer<PipelineSummary.Builder>... pipelines) {
            pipelines(Stream.of(pipelines).map(c -> PipelineSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelines(Collection<PipelineSummary.BuilderImpl> pipelines) {
            this.pipelines = PipelineListCopier.copyFromBuilder(pipelines);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
