/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The interaction or event that started a pipeline execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionTrigger implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionTrigger.Builder, ExecutionTrigger> {
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExecutionTrigger::triggerTypeAsString)).setter(setter(Builder::triggerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()).build();

    private static final SdkField<String> TRIGGER_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExecutionTrigger::triggerDetail)).setter(setter(Builder::triggerDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_TYPE_FIELD,
            TRIGGER_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String triggerType;

    private final String triggerDetail;

    private ExecutionTrigger(BuilderImpl builder) {
        this.triggerType = builder.triggerType;
        this.triggerDetail = builder.triggerDetail;
    }

    /**
     * <p>
     * The type of change-detection method, command, or user interaction that started a pipeline execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The type of change-detection method, command, or user interaction that started a pipeline execution.
     * @see TriggerType
     */
    public TriggerType triggerType() {
        return TriggerType.fromValue(triggerType);
    }

    /**
     * <p>
     * The type of change-detection method, command, or user interaction that started a pipeline execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The type of change-detection method, command, or user interaction that started a pipeline execution.
     * @see TriggerType
     */
    public String triggerTypeAsString() {
        return triggerType;
    }

    /**
     * <p>
     * Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that
     * triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code> CLI
     * command.
     * </p>
     * 
     * @return Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook
     *         that triggered the pipeline execution or the user ARN for a user-initiated
     *         <code>start-pipeline-execution</code> CLI command.
     */
    public String triggerDetail() {
        return triggerDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTrigger)) {
            return false;
        }
        ExecutionTrigger other = (ExecutionTrigger) obj;
        return Objects.equals(triggerTypeAsString(), other.triggerTypeAsString())
                && Objects.equals(triggerDetail(), other.triggerDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExecutionTrigger").add("TriggerType", triggerTypeAsString())
                .add("TriggerDetail", triggerDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "triggerType":
            return Optional.ofNullable(clazz.cast(triggerTypeAsString()));
        case "triggerDetail":
            return Optional.ofNullable(clazz.cast(triggerDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionTrigger, T> g) {
        return obj -> g.apply((ExecutionTrigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionTrigger> {
        /**
         * <p>
         * The type of change-detection method, command, or user interaction that started a pipeline execution.
         * </p>
         * 
         * @param triggerType
         *        The type of change-detection method, command, or user interaction that started a pipeline execution.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(String triggerType);

        /**
         * <p>
         * The type of change-detection method, command, or user interaction that started a pipeline execution.
         * </p>
         * 
         * @param triggerType
         *        The type of change-detection method, command, or user interaction that started a pipeline execution.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(TriggerType triggerType);

        /**
         * <p>
         * Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that
         * triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code>
         * CLI command.
         * </p>
         * 
         * @param triggerDetail
         *        Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook
         *        that triggered the pipeline execution or the user ARN for a user-initiated
         *        <code>start-pipeline-execution</code> CLI command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerDetail(String triggerDetail);
    }

    static final class BuilderImpl implements Builder {
        private String triggerType;

        private String triggerDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTrigger model) {
            triggerType(model.triggerType);
            triggerDetail(model.triggerDetail);
        }

        public final String getTriggerTypeAsString() {
            return triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        public final String getTriggerDetail() {
            return triggerDetail;
        }

        @Override
        public final Builder triggerDetail(String triggerDetail) {
            this.triggerDetail = triggerDetail;
            return this;
        }

        public final void setTriggerDetail(String triggerDetail) {
            this.triggerDetail = triggerDetail;
        }

        @Override
        public ExecutionTrigger build() {
            return new ExecutionTrigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
