/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Execution result information, such as the external execution ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionResult.Builder, ActionExecutionResult> {
    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionResult::externalExecutionId)).setter(setter(Builder::externalExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build())
            .build();

    private static final SdkField<String> EXTERNAL_EXECUTION_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionResult::externalExecutionSummary)).setter(setter(Builder::externalExecutionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionSummary").build())
            .build();

    private static final SdkField<String> EXTERNAL_EXECUTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionResult::externalExecutionUrl)).setter(setter(Builder::externalExecutionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_EXECUTION_ID_FIELD,
            EXTERNAL_EXECUTION_SUMMARY_FIELD, EXTERNAL_EXECUTION_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String externalExecutionId;

    private final String externalExecutionSummary;

    private final String externalExecutionUrl;

    private ActionExecutionResult(BuilderImpl builder) {
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionSummary = builder.externalExecutionSummary;
        this.externalExecutionUrl = builder.externalExecutionUrl;
    }

    /**
     * <p>
     * The action provider's external ID for the action execution.
     * </p>
     * 
     * @return The action provider's external ID for the action execution.
     */
    public String externalExecutionId() {
        return externalExecutionId;
    }

    /**
     * <p>
     * The action provider's summary for the action execution.
     * </p>
     * 
     * @return The action provider's summary for the action execution.
     */
    public String externalExecutionSummary() {
        return externalExecutionSummary;
    }

    /**
     * <p>
     * The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is
     * used when running the action.
     * </p>
     * 
     * @return The deepest external link to the external resource (for example, a repository URL or deployment endpoint)
     *         that is used when running the action.
     */
    public String externalExecutionUrl() {
        return externalExecutionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionResult)) {
            return false;
        }
        ActionExecutionResult other = (ActionExecutionResult) obj;
        return Objects.equals(externalExecutionId(), other.externalExecutionId())
                && Objects.equals(externalExecutionSummary(), other.externalExecutionSummary())
                && Objects.equals(externalExecutionUrl(), other.externalExecutionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActionExecutionResult").add("ExternalExecutionId", externalExecutionId())
                .add("ExternalExecutionSummary", externalExecutionSummary()).add("ExternalExecutionUrl", externalExecutionUrl())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalExecutionId":
            return Optional.ofNullable(clazz.cast(externalExecutionId()));
        case "externalExecutionSummary":
            return Optional.ofNullable(clazz.cast(externalExecutionSummary()));
        case "externalExecutionUrl":
            return Optional.ofNullable(clazz.cast(externalExecutionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionResult, T> g) {
        return obj -> g.apply((ActionExecutionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionResult> {
        /**
         * <p>
         * The action provider's external ID for the action execution.
         * </p>
         * 
         * @param externalExecutionId
         *        The action provider's external ID for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionId(String externalExecutionId);

        /**
         * <p>
         * The action provider's summary for the action execution.
         * </p>
         * 
         * @param externalExecutionSummary
         *        The action provider's summary for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionSummary(String externalExecutionSummary);

        /**
         * <p>
         * The deepest external link to the external resource (for example, a repository URL or deployment endpoint)
         * that is used when running the action.
         * </p>
         * 
         * @param externalExecutionUrl
         *        The deepest external link to the external resource (for example, a repository URL or deployment
         *        endpoint) that is used when running the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionUrl(String externalExecutionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String externalExecutionId;

        private String externalExecutionSummary;

        private String externalExecutionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionResult model) {
            externalExecutionId(model.externalExecutionId);
            externalExecutionSummary(model.externalExecutionSummary);
            externalExecutionUrl(model.externalExecutionUrl);
        }

        public final String getExternalExecutionId() {
            return externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public final String getExternalExecutionSummary() {
            return externalExecutionSummary;
        }

        @Override
        public final Builder externalExecutionSummary(String externalExecutionSummary) {
            this.externalExecutionSummary = externalExecutionSummary;
            return this;
        }

        public final void setExternalExecutionSummary(String externalExecutionSummary) {
            this.externalExecutionSummary = externalExecutionSummary;
        }

        public final String getExternalExecutionUrl() {
            return externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        @Override
        public ActionExecutionResult build() {
            return new ActionExecutionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
