/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.FailureType;
import software.amazon.awssdk.services.codepipeline.transform.FailureDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FailureDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, FailureDetails> {
    private final String type;
    private final String message;
    private final String externalExecutionId;

    private FailureDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
        this.externalExecutionId = builder.externalExecutionId;
    }

    public FailureType type() {
        return FailureType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String externalExecutionId() {
        return this.externalExecutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalExecutionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.externalExecutionId(), other.externalExecutionId());
    }

    public String toString() {
        return ToString.builder((String)"FailureDetails").add("Type", (Object)this.typeString()).add("Message", (Object)this.message()).add("ExternalExecutionId", (Object)this.externalExecutionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "externalExecutionId": {
                return Optional.of(clazz.cast(this.externalExecutionId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailureDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;
        private String externalExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            this.type(model.type);
            this.message(model.message);
            this.externalExecutionId(model.externalExecutionId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FailureType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public FailureDetails build() {
            return new FailureDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailureDetails> {
        public Builder type(String var1);

        public Builder type(FailureType var1);

        public Builder message(String var1);

        public Builder externalExecutionId(String var1);
    }
}

