/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ExecutionDetails;

@SdkInternalApi
public class ExecutionDetailsMarshaller {
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionId").build();
    private static final MarshallingInfo<Integer> PERCENTCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentComplete").build();
    private static final ExecutionDetailsMarshaller INSTANCE = new ExecutionDetailsMarshaller();

    public static ExecutionDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExecutionDetails executionDetails, ProtocolMarshaller protocolMarshaller) {
        if (executionDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)executionDetails.summary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)executionDetails.externalExecutionId(), EXTERNALEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)executionDetails.percentComplete(), PERCENTCOMPLETE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

