/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.codepipeline.model.ActionType;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeListCopier;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListActionTypesResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, ListActionTypesResponse> {
    private final List<ActionType> actionTypes;
    private final String nextToken;

    private ListActionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.actionTypes = builder.actionTypes;
        this.nextToken = builder.nextToken;
    }

    public List<ActionType> actionTypes() {
        return this.actionTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesResponse)) {
            return false;
        }
        ListActionTypesResponse other = (ListActionTypesResponse)((Object)obj);
        return Objects.equals(this.actionTypes(), other.actionTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListActionTypesResponse").add("ActionTypes", this.actionTypes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypes": {
                return Optional.of(clazz.cast(this.actionTypes()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<ActionType> actionTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesResponse model) {
            this.actionTypes(model.actionTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<ActionType.Builder> getActionTypes() {
            return this.actionTypes != null ? (Collection)this.actionTypes.stream().map(ActionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionTypes(Collection<ActionType> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copy(actionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypes(ActionType ... actionTypes) {
            this.actionTypes(Arrays.asList(actionTypes));
            return this;
        }

        public final void setActionTypes(Collection<ActionType.BuilderImpl> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copyFromBuilder(actionTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListActionTypesResponse build() {
            return new ListActionTypesResponse(this);
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    CopyableBuilder<Builder, ListActionTypesResponse> {
        public Builder actionTypes(Collection<ActionType> var1);

        public Builder actionTypes(ActionType ... var1);

        public Builder nextToken(String var1);
    }
}

