/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;

@SdkInternalApi
public class ActionRevisionMarshaller {
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionId").build();
    private static final MarshallingInfo<String> REVISIONCHANGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionChangeId").build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").build();
    private static final ActionRevisionMarshaller INSTANCE = new ActionRevisionMarshaller();

    public static ActionRevisionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionRevision actionRevision, ProtocolMarshaller protocolMarshaller) {
        if (actionRevision == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)actionRevision.revisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall((Object)actionRevision.revisionChangeId(), REVISIONCHANGEID_BINDING);
            protocolMarshaller.marshall((Object)actionRevision.created(), CREATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

