/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.CurrentRevision;
import software.amazon.awssdk.services.codepipeline.model.ExecutionDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutJobSuccessResultRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutJobSuccessResultRequest> {
    private final String jobId;
    private final CurrentRevision currentRevision;
    private final String continuationToken;
    private final ExecutionDetails executionDetails;

    private PutJobSuccessResultRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.currentRevision = builder.currentRevision;
        this.continuationToken = builder.continuationToken;
        this.executionDetails = builder.executionDetails;
    }

    public String jobId() {
        return this.jobId;
    }

    public CurrentRevision currentRevision() {
        return this.currentRevision;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public ExecutionDetails executionDetails() {
        return this.executionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.currentRevision() == null ? 0 : this.currentRevision().hashCode());
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        hashCode = 31 * hashCode + (this.executionDetails() == null ? 0 : this.executionDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutJobSuccessResultRequest)) {
            return false;
        }
        PutJobSuccessResultRequest other = (PutJobSuccessResultRequest)((Object)obj);
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.currentRevision() == null ^ this.currentRevision() == null) {
            return false;
        }
        if (other.currentRevision() != null && !other.currentRevision().equals(this.currentRevision())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.executionDetails() == null ^ this.executionDetails() == null) {
            return false;
        }
        return other.executionDetails() == null || other.executionDetails().equals(this.executionDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.currentRevision() != null) {
            sb.append("CurrentRevision: ").append(this.currentRevision()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.executionDetails() != null) {
            sb.append("ExecutionDetails: ").append(this.executionDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "currentRevision": {
                return Optional.of(clazz.cast(this.currentRevision()));
            }
            case "continuationToken": {
                return Optional.of(clazz.cast(this.continuationToken()));
            }
            case "executionDetails": {
                return Optional.of(clazz.cast(this.executionDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private CurrentRevision currentRevision;
        private String continuationToken;
        private ExecutionDetails executionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutJobSuccessResultRequest model) {
            this.jobId(model.jobId);
            this.currentRevision(model.currentRevision);
            this.continuationToken(model.continuationToken);
            this.executionDetails(model.executionDetails);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final CurrentRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        @Override
        public final Builder currentRevision(CurrentRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final void setCurrentRevision(CurrentRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return this.executionDetails != null ? this.executionDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        public PutJobSuccessResultRequest build() {
            return new PutJobSuccessResultRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutJobSuccessResultRequest> {
        public Builder jobId(String var1);

        public Builder currentRevision(CurrentRevision var1);

        public Builder continuationToken(String var1);

        public Builder executionDetails(ExecutionDetails var1);
    }
}

