/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.PipelineListCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPipelinesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPipelinesResponse> {
    private final List<PipelineSummary> pipelines;
    private final String nextToken;

    private ListPipelinesResponse(BuilderImpl builder) {
        this.pipelines = builder.pipelines;
        this.nextToken = builder.nextToken;
    }

    public List<PipelineSummary> pipelines() {
        return this.pipelines;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelines() == null ? 0 : this.pipelines().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse)((Object)obj);
        if (other.pipelines() == null ^ this.pipelines() == null) {
            return false;
        }
        if (other.pipelines() != null && !other.pipelines().equals(this.pipelines())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelines() != null) {
            sb.append("Pipelines: ").append(this.pipelines()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelines": {
                return Optional.of(clazz.cast(this.pipelines()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PipelineSummary> pipelines;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            this.pipelines(model.pipelines);
            this.nextToken(model.nextToken);
        }

        public final Collection<PipelineSummary.Builder> getPipelines() {
            return this.pipelines != null ? (Collection)this.pipelines.stream().map(PipelineSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelines(Collection<PipelineSummary> pipelines) {
            this.pipelines = PipelineListCopier.copy(pipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(PipelineSummary ... pipelines) {
            this.pipelines(Arrays.asList(pipelines));
            return this;
        }

        public final void setPipelines(Collection<PipelineSummary.BuilderImpl> pipelines) {
            this.pipelines = PipelineListCopier.copyFromBuilder(pipelines);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPipelinesResponse> {
        public Builder pipelines(Collection<PipelineSummary> var1);

        public Builder pipelines(PipelineSummary ... var1);

        public Builder nextToken(String var1);
    }
}

