/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.JobData;
import software.amazon.awssdk.services.codepipeline.transform.JobDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, JobDetails> {
    private final String id;
    private final JobData data;
    private final String accountId;

    private JobDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.accountId = builder.accountId;
    }

    public String id() {
        return this.id;
    }

    public JobData data() {
        return this.data;
    }

    public String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        return other.accountId() == null || other.accountId().equals(this.accountId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private JobData data;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            this.id(model.id);
            this.data(model.data);
            this.accountId(model.accountId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final JobData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        @Override
        public final Builder data(JobData data) {
            this.data = data;
            return this;
        }

        public final void setData(JobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public JobDetails build() {
            return new JobDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobDetails> {
        public Builder id(String var1);

        public Builder data(JobData var1);

        public Builder accountId(String var1);
    }
}

