/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteCustomActionTypeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteCustomActionTypeRequest> {
    private final String category;
    private final String provider;
    private final String version;

    private DeleteCustomActionTypeRequest(BuilderImpl builder) {
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    public ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public String categoryString() {
        return this.category;
    }

    public String provider() {
        return this.provider;
    }

    public String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.categoryString() == null ? 0 : this.categoryString().hashCode());
        hashCode = 31 * hashCode + (this.provider() == null ? 0 : this.provider().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomActionTypeRequest)) {
            return false;
        }
        DeleteCustomActionTypeRequest other = (DeleteCustomActionTypeRequest)((Object)obj);
        if (other.categoryString() == null ^ this.categoryString() == null) {
            return false;
        }
        if (other.categoryString() != null && !other.categoryString().equals(this.categoryString())) {
            return false;
        }
        if (other.provider() == null ^ this.provider() == null) {
            return false;
        }
        if (other.provider() != null && !other.provider().equals(this.provider())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.categoryString() != null) {
            sb.append("Category: ").append(this.categoryString()).append(",");
        }
        if (this.provider() != null) {
            sb.append("Provider: ").append(this.provider()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.of(clazz.cast(this.categoryString()));
            }
            case "provider": {
                return Optional.of(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String provider;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomActionTypeRequest model) {
            this.category(model.category);
            this.provider(model.provider);
            this.version(model.version);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public DeleteCustomActionTypeRequest build() {
            return new DeleteCustomActionTypeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteCustomActionTypeRequest> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder provider(String var1);

        public Builder version(String var1);
    }
}

