/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyListCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeSettings;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCustomActionTypeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateCustomActionTypeRequest> {
    private final String category;
    private final String provider;
    private final String version;
    private final ActionTypeSettings settings;
    private final List<ActionConfigurationProperty> configurationProperties;
    private final ArtifactDetails inputArtifactDetails;
    private final ArtifactDetails outputArtifactDetails;

    private CreateCustomActionTypeRequest(BuilderImpl builder) {
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
        this.settings = builder.settings;
        this.configurationProperties = builder.configurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
    }

    public ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public String categoryString() {
        return this.category;
    }

    public String provider() {
        return this.provider;
    }

    public String version() {
        return this.version;
    }

    public ActionTypeSettings settings() {
        return this.settings;
    }

    public List<ActionConfigurationProperty> configurationProperties() {
        return this.configurationProperties;
    }

    public ArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public ArtifactDetails outputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.categoryString() == null ? 0 : this.categoryString().hashCode());
        hashCode = 31 * hashCode + (this.provider() == null ? 0 : this.provider().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.settings() == null ? 0 : this.settings().hashCode());
        hashCode = 31 * hashCode + (this.configurationProperties() == null ? 0 : this.configurationProperties().hashCode());
        hashCode = 31 * hashCode + (this.inputArtifactDetails() == null ? 0 : this.inputArtifactDetails().hashCode());
        hashCode = 31 * hashCode + (this.outputArtifactDetails() == null ? 0 : this.outputArtifactDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomActionTypeRequest)) {
            return false;
        }
        CreateCustomActionTypeRequest other = (CreateCustomActionTypeRequest)((Object)obj);
        if (other.categoryString() == null ^ this.categoryString() == null) {
            return false;
        }
        if (other.categoryString() != null && !other.categoryString().equals(this.categoryString())) {
            return false;
        }
        if (other.provider() == null ^ this.provider() == null) {
            return false;
        }
        if (other.provider() != null && !other.provider().equals(this.provider())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.settings() == null ^ this.settings() == null) {
            return false;
        }
        if (other.settings() != null && !other.settings().equals(this.settings())) {
            return false;
        }
        if (other.configurationProperties() == null ^ this.configurationProperties() == null) {
            return false;
        }
        if (other.configurationProperties() != null && !other.configurationProperties().equals(this.configurationProperties())) {
            return false;
        }
        if (other.inputArtifactDetails() == null ^ this.inputArtifactDetails() == null) {
            return false;
        }
        if (other.inputArtifactDetails() != null && !other.inputArtifactDetails().equals(this.inputArtifactDetails())) {
            return false;
        }
        if (other.outputArtifactDetails() == null ^ this.outputArtifactDetails() == null) {
            return false;
        }
        return other.outputArtifactDetails() == null || other.outputArtifactDetails().equals(this.outputArtifactDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.categoryString() != null) {
            sb.append("Category: ").append(this.categoryString()).append(",");
        }
        if (this.provider() != null) {
            sb.append("Provider: ").append(this.provider()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.settings() != null) {
            sb.append("Settings: ").append(this.settings()).append(",");
        }
        if (this.configurationProperties() != null) {
            sb.append("ConfigurationProperties: ").append(this.configurationProperties()).append(",");
        }
        if (this.inputArtifactDetails() != null) {
            sb.append("InputArtifactDetails: ").append(this.inputArtifactDetails()).append(",");
        }
        if (this.outputArtifactDetails() != null) {
            sb.append("OutputArtifactDetails: ").append(this.outputArtifactDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.of(clazz.cast(this.categoryString()));
            }
            case "provider": {
                return Optional.of(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "settings": {
                return Optional.of(clazz.cast(this.settings()));
            }
            case "configurationProperties": {
                return Optional.of(clazz.cast(this.configurationProperties()));
            }
            case "inputArtifactDetails": {
                return Optional.of(clazz.cast(this.inputArtifactDetails()));
            }
            case "outputArtifactDetails": {
                return Optional.of(clazz.cast(this.outputArtifactDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String provider;
        private String version;
        private ActionTypeSettings settings;
        private List<ActionConfigurationProperty> configurationProperties;
        private ArtifactDetails inputArtifactDetails;
        private ArtifactDetails outputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomActionTypeRequest model) {
            this.category(model.category);
            this.provider(model.provider);
            this.version(model.version);
            this.settings(model.settings);
            this.configurationProperties(model.configurationProperties);
            this.inputArtifactDetails(model.inputArtifactDetails);
            this.outputArtifactDetails(model.outputArtifactDetails);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final Collection<ActionConfigurationProperty.Builder> getConfigurationProperties() {
            return this.configurationProperties != null ? (Collection)this.configurationProperties.stream().map(ActionConfigurationProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationProperties(Collection<ActionConfigurationProperty> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(ActionConfigurationProperty ... configurationProperties) {
            this.configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        public final void setConfigurationProperties(Collection<ActionConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copyFromBuilder(configurationProperties);
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return this.outputArtifactDetails != null ? this.outputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        public CreateCustomActionTypeRequest build() {
            return new CreateCustomActionTypeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCustomActionTypeRequest> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder provider(String var1);

        public Builder version(String var1);

        public Builder settings(ActionTypeSettings var1);

        public Builder configurationProperties(Collection<ActionConfigurationProperty> var1);

        public Builder configurationProperties(ActionConfigurationProperty ... var1);

        public Builder inputArtifactDetails(ArtifactDetails var1);

        public Builder outputArtifactDetails(ArtifactDetails var1);
    }
}

