/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactLocation;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Artifact
implements StructuredPojo,
ToCopyableBuilder<Builder, Artifact> {
    private final String name;
    private final String revision;
    private final ArtifactLocation location;

    private Artifact(BuilderImpl builder) {
        this.name = builder.name;
        this.revision = builder.revision;
        this.location = builder.location;
    }

    public String name() {
        return this.name;
    }

    public String revision() {
        return this.revision;
    }

    public ArtifactLocation location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        return other.location() == null || other.location().equals(this.location());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String revision;
        private ArtifactLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            this.name(model.name);
            this.revision(model.revision);
            this.location(model.location);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public final ArtifactLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ArtifactLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ArtifactLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public Artifact build() {
            return new Artifact(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Artifact> {
        public Builder name(String var1);

        public Builder revision(String var1);

        public Builder location(ArtifactLocation var1);
    }
}

