/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WebhookFilterRuleMarshaller {
    private static final MarshallingInfo<String> JSONPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jsonPath").isBinary(false).build();
    private static final MarshallingInfo<String> MATCHEQUALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("matchEquals").isBinary(false).build();
    private static final WebhookFilterRuleMarshaller INSTANCE = new WebhookFilterRuleMarshaller();

    private WebhookFilterRuleMarshaller() {
    }

    public static WebhookFilterRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WebhookFilterRule webhookFilterRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)webhookFilterRule, (String)"webhookFilterRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)webhookFilterRule.jsonPath(), JSONPATH_BINDING);
            protocolMarshaller.marshall((Object)webhookFilterRule.matchEquals(), MATCHEQUALS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

