/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WebhookAuthConfigurationMarshaller {
    private static final MarshallingInfo<String> ALLOWEDIPRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedIPRange").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretToken").isBinary(false).build();
    private static final WebhookAuthConfigurationMarshaller INSTANCE = new WebhookAuthConfigurationMarshaller();

    private WebhookAuthConfigurationMarshaller() {
    }

    public static WebhookAuthConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WebhookAuthConfiguration webhookAuthConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)webhookAuthConfiguration, (String)"webhookAuthConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)webhookAuthConfiguration.allowedIPRange(), ALLOWEDIPRANGE_BINDING);
            protocolMarshaller.marshall((Object)webhookAuthConfiguration.secretToken(), SECRETTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

