/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.WebhookFilterRuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebhookFilterRule
implements StructuredPojo,
ToCopyableBuilder<Builder, WebhookFilterRule> {
    private final String jsonPath;
    private final String matchEquals;

    private WebhookFilterRule(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.matchEquals = builder.matchEquals;
    }

    public String jsonPath() {
        return this.jsonPath;
    }

    public String matchEquals() {
        return this.matchEquals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchEquals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookFilterRule)) {
            return false;
        }
        WebhookFilterRule other = (WebhookFilterRule)obj;
        return Objects.equals(this.jsonPath(), other.jsonPath()) && Objects.equals(this.matchEquals(), other.matchEquals());
    }

    public String toString() {
        return ToString.builder((String)"WebhookFilterRule").add("JsonPath", (Object)this.jsonPath()).add("MatchEquals", (Object)this.matchEquals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jsonPath": {
                return Optional.ofNullable(clazz.cast(this.jsonPath()));
            }
            case "matchEquals": {
                return Optional.ofNullable(clazz.cast(this.matchEquals()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebhookFilterRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jsonPath;
        private String matchEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookFilterRule model) {
            this.jsonPath(model.jsonPath);
            this.matchEquals(model.matchEquals);
        }

        public final String getJsonPath() {
            return this.jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        public final String getMatchEquals() {
            return this.matchEquals;
        }

        @Override
        public final Builder matchEquals(String matchEquals) {
            this.matchEquals = matchEquals;
            return this;
        }

        public final void setMatchEquals(String matchEquals) {
            this.matchEquals = matchEquals;
        }

        public WebhookFilterRule build() {
            return new WebhookFilterRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebhookFilterRule> {
        public Builder jsonPath(String var1);

        public Builder matchEquals(String var1);
    }
}

