/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.PipelineMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PipelineMetadataMarshaller {
    private static final MarshallingInfo<String> PIPELINEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<Instant> UPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updated").isBinary(false).build();
    private static final PipelineMetadataMarshaller INSTANCE = new PipelineMetadataMarshaller();

    private PipelineMetadataMarshaller() {
    }

    public static PipelineMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineMetadata pipelineMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pipelineMetadata, (String)"pipelineMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pipelineMetadata.pipelineArn(), PIPELINEARN_BINDING);
            protocolMarshaller.marshall((Object)pipelineMetadata.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)pipelineMetadata.updated(), UPDATED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

