/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionDeclaration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActionDeclarationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionTypeId").isBinary(false).build();
    private static final MarshallingInfo<Integer> RUNORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runOrder").isBinary(false).build();
    private static final MarshallingInfo<Map> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputArtifacts").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputArtifacts").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final ActionDeclarationMarshaller INSTANCE = new ActionDeclarationMarshaller();

    private ActionDeclarationMarshaller() {
    }

    public static ActionDeclarationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionDeclaration actionDeclaration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)actionDeclaration, (String)"actionDeclaration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)actionDeclaration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)actionDeclaration.actionTypeId(), ACTIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)actionDeclaration.runOrder(), RUNORDER_BINDING);
            protocolMarshaller.marshall(actionDeclaration.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(actionDeclaration.outputArtifacts(), OUTPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall(actionDeclaration.inputArtifacts(), INPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)actionDeclaration.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

