/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.Job;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("data").isBinary(false).build();
    private static final MarshallingInfo<String> NONCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonce").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();
    private static final JobMarshaller INSTANCE = new JobMarshaller();

    private JobMarshaller() {
    }

    public static JobMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Job job, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)job, (String)"job");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)job.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)job.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)job.nonce(), NONCE_BINDING);
            protocolMarshaller.marshall((Object)job.accountId(), ACCOUNTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

