/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.CurrentRevision;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CurrentRevisionMarshaller {
    private static final MarshallingInfo<String> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").isBinary(false).build();
    private static final MarshallingInfo<String> CHANGEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("changeIdentifier").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionSummary").isBinary(false).build();
    private static final CurrentRevisionMarshaller INSTANCE = new CurrentRevisionMarshaller();

    private CurrentRevisionMarshaller() {
    }

    public static CurrentRevisionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CurrentRevision currentRevision, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)currentRevision, (String)"currentRevision");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)currentRevision.revision(), REVISION_BINDING);
            protocolMarshaller.marshall((Object)currentRevision.changeIdentifier(), CHANGEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)currentRevision.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)currentRevision.revisionSummary(), REVISIONSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

