/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionTypeSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionTypeSettings> {
    private final String thirdPartyConfigurationUrl;
    private final String entityUrlTemplate;
    private final String executionUrlTemplate;
    private final String revisionUrlTemplate;

    private ActionTypeSettings(BuilderImpl builder) {
        this.thirdPartyConfigurationUrl = builder.thirdPartyConfigurationUrl;
        this.entityUrlTemplate = builder.entityUrlTemplate;
        this.executionUrlTemplate = builder.executionUrlTemplate;
        this.revisionUrlTemplate = builder.revisionUrlTemplate;
    }

    public String thirdPartyConfigurationUrl() {
        return this.thirdPartyConfigurationUrl;
    }

    public String entityUrlTemplate() {
        return this.entityUrlTemplate;
    }

    public String executionUrlTemplate() {
        return this.executionUrlTemplate;
    }

    public String revisionUrlTemplate() {
        return this.revisionUrlTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thirdPartyConfigurationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityUrlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionUrlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrlTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeSettings)) {
            return false;
        }
        ActionTypeSettings other = (ActionTypeSettings)obj;
        return Objects.equals(this.thirdPartyConfigurationUrl(), other.thirdPartyConfigurationUrl()) && Objects.equals(this.entityUrlTemplate(), other.entityUrlTemplate()) && Objects.equals(this.executionUrlTemplate(), other.executionUrlTemplate()) && Objects.equals(this.revisionUrlTemplate(), other.revisionUrlTemplate());
    }

    public String toString() {
        return ToString.builder((String)"ActionTypeSettings").add("ThirdPartyConfigurationUrl", (Object)this.thirdPartyConfigurationUrl()).add("EntityUrlTemplate", (Object)this.entityUrlTemplate()).add("ExecutionUrlTemplate", (Object)this.executionUrlTemplate()).add("RevisionUrlTemplate", (Object)this.revisionUrlTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thirdPartyConfigurationUrl": {
                return Optional.of(clazz.cast(this.thirdPartyConfigurationUrl()));
            }
            case "entityUrlTemplate": {
                return Optional.of(clazz.cast(this.entityUrlTemplate()));
            }
            case "executionUrlTemplate": {
                return Optional.of(clazz.cast(this.executionUrlTemplate()));
            }
            case "revisionUrlTemplate": {
                return Optional.of(clazz.cast(this.revisionUrlTemplate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionTypeSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thirdPartyConfigurationUrl;
        private String entityUrlTemplate;
        private String executionUrlTemplate;
        private String revisionUrlTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeSettings model) {
            this.thirdPartyConfigurationUrl(model.thirdPartyConfigurationUrl);
            this.entityUrlTemplate(model.entityUrlTemplate);
            this.executionUrlTemplate(model.executionUrlTemplate);
            this.revisionUrlTemplate(model.revisionUrlTemplate);
        }

        public final String getThirdPartyConfigurationUrl() {
            return this.thirdPartyConfigurationUrl;
        }

        @Override
        public final Builder thirdPartyConfigurationUrl(String thirdPartyConfigurationUrl) {
            this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
            return this;
        }

        public final void setThirdPartyConfigurationUrl(String thirdPartyConfigurationUrl) {
            this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
        }

        public final String getEntityUrlTemplate() {
            return this.entityUrlTemplate;
        }

        @Override
        public final Builder entityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
            return this;
        }

        public final void setEntityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
        }

        public final String getExecutionUrlTemplate() {
            return this.executionUrlTemplate;
        }

        @Override
        public final Builder executionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
            return this;
        }

        public final void setExecutionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
        }

        public final String getRevisionUrlTemplate() {
            return this.revisionUrlTemplate;
        }

        @Override
        public final Builder revisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
            return this;
        }

        public final void setRevisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
        }

        public ActionTypeSettings build() {
            return new ActionTypeSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionTypeSettings> {
        public Builder thirdPartyConfigurationUrl(String var1);

        public Builder entityUrlTemplate(String var1);

        public Builder executionUrlTemplate(String var1);

        public Builder revisionUrlTemplate(String var1);
    }
}

