/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType;
import software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArtifactLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, ArtifactLocation> {
    private final String type;
    private final S3ArtifactLocation s3Location;

    private ArtifactLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Location = builder.s3Location;
    }

    public String type() {
        return this.type;
    }

    public S3ArtifactLocation s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.s3Location() == null ? 0 : this.s3Location().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactLocation)) {
            return false;
        }
        ArtifactLocation other = (ArtifactLocation)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.s3Location() == null ^ this.s3Location() == null) {
            return false;
        }
        return other.s3Location() == null || other.s3Location().equals(this.s3Location());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.s3Location() != null) {
            sb.append("S3Location: ").append(this.s3Location()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private S3ArtifactLocation s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactLocation model) {
            this.setType(model.type);
            this.setS3Location(model.s3Location);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactLocationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ArtifactLocationType type) {
            this.type(type.toString());
        }

        public final S3ArtifactLocation getS3Location() {
            return this.s3Location;
        }

        @Override
        public final Builder s3Location(S3ArtifactLocation s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3ArtifactLocation s3Location) {
            this.s3Location = s3Location;
        }

        public ArtifactLocation build() {
            return new ArtifactLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArtifactLocation> {
        public Builder type(String var1);

        public Builder type(ArtifactLocationType var1);

        public Builder s3Location(S3ArtifactLocation var1);
    }
}

