/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClient;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClientBuilder;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerServiceClientConfiguration;
import software.amazon.awssdk.services.codegurureviewer.DefaultCodeGuruReviewerAsyncClient;
import software.amazon.awssdk.services.codegurureviewer.DefaultCodeGuruReviewerBaseClientBuilder;
import software.amazon.awssdk.services.codegurureviewer.endpoints.CodeGuruReviewerEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruReviewerAsyncClientBuilder
extends DefaultCodeGuruReviewerBaseClientBuilder<CodeGuruReviewerAsyncClientBuilder, CodeGuruReviewerAsyncClient>
implements CodeGuruReviewerAsyncClientBuilder {
    DefaultCodeGuruReviewerAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeGuruReviewerAsyncClientBuilder endpointProvider(CodeGuruReviewerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruReviewerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeGuruReviewerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeGuruReviewerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeGuruReviewerAsyncClient client = new DefaultCodeGuruReviewerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeGuruReviewerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeGuruReviewerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

