/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RecommendationCategory {
    AWS_BEST_PRACTICES("AWSBestPractices"),
    AWS_CLOUD_FORMATION_ISSUES("AWSCloudFormationIssues"),
    DUPLICATE_CODE("DuplicateCode"),
    CODE_MAINTENANCE_ISSUES("CodeMaintenanceIssues"),
    CONCURRENCY_ISSUES("ConcurrencyIssues"),
    INPUT_VALIDATIONS("InputValidations"),
    PYTHON_BEST_PRACTICES("PythonBestPractices"),
    JAVA_BEST_PRACTICES("JavaBestPractices"),
    RESOURCE_LEAKS("ResourceLeaks"),
    SECURITY_ISSUES("SecurityIssues"),
    CODE_INCONSISTENCIES("CodeInconsistencies"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RecommendationCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RecommendationCategory.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationCategory> knownValues() {
        return Stream.of(RecommendationCategory.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

