/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a code review. A code review belongs to the associated repository that contains the reviewed code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeReview implements SdkPojo, Serializable, ToCopyableBuilder<CodeReview.Builder, CodeReview> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CodeReview::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeReviewArn").getter(getter(CodeReview::codeReviewArn)).setter(setter(Builder::codeReviewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewArn").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(CodeReview::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(CodeReview::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(CodeReview::providerTypeAsString)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CodeReview::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(CodeReview::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<Instant> CREATED_TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimeStamp").getter(getter(CodeReview::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimeStamp").getter(getter(CodeReview::lastUpdatedTimeStamp))
            .setter(setter(Builder::lastUpdatedTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CodeReview::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PullRequestId").getter(getter(CodeReview::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PullRequestId").build()).build();

    private static final SdkField<SourceCodeType> SOURCE_CODE_TYPE_FIELD = SdkField
            .<SourceCodeType> builder(MarshallingType.SDK_POJO).memberName("SourceCodeType")
            .getter(getter(CodeReview::sourceCodeType)).setter(setter(Builder::sourceCodeType))
            .constructor(SourceCodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeType").build()).build();

    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationArn").getter(getter(CodeReview::associationArn)).setter(setter(Builder::associationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationArn").build()).build();

    private static final SdkField<Metrics> METRICS_FIELD = SdkField.<Metrics> builder(MarshallingType.SDK_POJO)
            .memberName("Metrics").getter(getter(CodeReview::metrics)).setter(setter(Builder::metrics))
            .constructor(Metrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CODE_REVIEW_ARN_FIELD, REPOSITORY_NAME_FIELD, OWNER_FIELD, PROVIDER_TYPE_FIELD, STATE_FIELD, STATE_REASON_FIELD,
            CREATED_TIME_STAMP_FIELD, LAST_UPDATED_TIME_STAMP_FIELD, TYPE_FIELD, PULL_REQUEST_ID_FIELD, SOURCE_CODE_TYPE_FIELD,
            ASSOCIATION_ARN_FIELD, METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String codeReviewArn;

    private final String repositoryName;

    private final String owner;

    private final String providerType;

    private final String state;

    private final String stateReason;

    private final Instant createdTimeStamp;

    private final Instant lastUpdatedTimeStamp;

    private final String type;

    private final String pullRequestId;

    private final SourceCodeType sourceCodeType;

    private final String associationArn;

    private final Metrics metrics;

    private CodeReview(BuilderImpl builder) {
        this.name = builder.name;
        this.codeReviewArn = builder.codeReviewArn;
        this.repositoryName = builder.repositoryName;
        this.owner = builder.owner;
        this.providerType = builder.providerType;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
        this.type = builder.type;
        this.pullRequestId = builder.pullRequestId;
        this.sourceCodeType = builder.sourceCodeType;
        this.associationArn = builder.associationArn;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The name of the code review.
     * </p>
     * 
     * @return The name of the code review.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a>
     * object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     *         <code>CodeReview</code> </a> object.
     */
    public final String codeReviewArn() {
        return codeReviewArn;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account that
     * owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for
     * the account that owns the repository.
     * </p>
     * 
     * @return The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account
     *         that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the
     *         username for the account that owns the repository.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The valid code review states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The code review is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code>: The code review started and has not completed or failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The code review failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: The code review is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The valid code review states are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The code review is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code>: The code review started and has not completed or failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The code review failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: The code review is being deleted.
     *         </p>
     *         </li>
     * @see JobState
     */
    public final JobState state() {
        return JobState.fromValue(state);
    }

    /**
     * <p>
     * The valid code review states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The code review is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code>: The code review started and has not completed or failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The code review failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: The code review is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The valid code review states are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The code review is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code>: The code review started and has not completed or failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The code review failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: The code review is being deleted.
     *         </p>
     *         </li>
     * @see JobState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the state of the code review.
     * </p>
     * 
     * @return The reason for the state of the code review.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the code review was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the code review was created.
     */
    public final Instant createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the code review was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the code review was last updated.
     */
    public final Instant lastUpdatedTimeStamp() {
        return lastUpdatedTimeStamp;
    }

    /**
     * <p>
     * The type of code review.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of code review.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of code review.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of code review.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The pull request ID for the code review.
     * </p>
     * 
     * @return The pull request ID for the code review.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The type of the source code for the code review.
     * </p>
     * 
     * @return The type of the source code for the code review.
     */
    public final SourceCodeType sourceCodeType() {
        return sourceCodeType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * <code>RepositoryAssociation</code> </a> that contains the reviewed source code. You can retrieve associated
     * repository ARNs by calling <a
     * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * <code>ListRepositoryAssociations</code> </a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     *         <code>RepositoryAssociation</code> </a> that contains the reviewed source code. You can retrieve
     *         associated repository ARNs by calling <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     *         <code>ListRepositoryAssociations</code> </a>.
     */
    public final String associationArn() {
        return associationArn;
    }

    /**
     * <p>
     * The statistics from the code review.
     * </p>
     * 
     * @return The statistics from the code review.
     */
    public final Metrics metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeType());
        hashCode = 31 * hashCode + Objects.hashCode(associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeReview)) {
            return false;
        }
        CodeReview other = (CodeReview) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(codeReviewArn(), other.codeReviewArn())
                && Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(owner(), other.owner())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(createdTimeStamp(), other.createdTimeStamp())
                && Objects.equals(lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(sourceCodeType(), other.sourceCodeType())
                && Objects.equals(associationArn(), other.associationArn()) && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeReview").add("Name", name()).add("CodeReviewArn", codeReviewArn())
                .add("RepositoryName", repositoryName()).add("Owner", owner()).add("ProviderType", providerTypeAsString())
                .add("State", stateAsString()).add("StateReason", stateReason()).add("CreatedTimeStamp", createdTimeStamp())
                .add("LastUpdatedTimeStamp", lastUpdatedTimeStamp()).add("Type", typeAsString())
                .add("PullRequestId", pullRequestId()).add("SourceCodeType", sourceCodeType())
                .add("AssociationArn", associationArn()).add("Metrics", metrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CodeReviewArn":
            return Optional.ofNullable(clazz.cast(codeReviewArn()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "LastUpdatedTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimeStamp()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "PullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "SourceCodeType":
            return Optional.ofNullable(clazz.cast(sourceCodeType()));
        case "AssociationArn":
            return Optional.ofNullable(clazz.cast(associationArn()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeReview, T> g) {
        return obj -> g.apply((CodeReview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeReview> {
        /**
         * <p>
         * The name of the code review.
         * </p>
         * 
         * @param name
         *        The name of the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code>
         * </a> object.
         * </p>
         * 
         * @param codeReviewArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         *        <code>CodeReview</code> </a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewArn(String codeReviewArn);

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account that
         * owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username
         * for the account that owns the repository.
         * </p>
         * 
         * @param owner
         *        The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the
         *        account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository,
         *        this is the username for the account that owns the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         * </p>
         * 
         * @param providerType
         *        The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         * </p>
         * 
         * @param providerType
         *        The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The valid code review states are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder state(String state);

        /**
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The valid code review states are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @see JobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobState
         */
        Builder state(JobState state);

        /**
         * <p>
         * The reason for the state of the code review.
         * </p>
         * 
         * @param stateReason
         *        The reason for the state of the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the code review was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The time, in milliseconds since the epoch, when the code review was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Instant createdTimeStamp);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the code review was last updated.
         * </p>
         * 
         * @param lastUpdatedTimeStamp
         *        The time, in milliseconds since the epoch, when the code review was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp);

        /**
         * <p>
         * The type of code review.
         * </p>
         * 
         * @param type
         *        The type of code review.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of code review.
         * </p>
         * 
         * @param type
         *        The type of code review.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * The pull request ID for the code review.
         * </p>
         * 
         * @param pullRequestId
         *        The pull request ID for the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The type of the source code for the code review.
         * </p>
         * 
         * @param sourceCodeType
         *        The type of the source code for the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeType(SourceCodeType sourceCodeType);

        /**
         * <p>
         * The type of the source code for the code review.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceCodeType.Builder} avoiding the need to
         * create one manually via {@link SourceCodeType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceCodeType.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceCodeType(SourceCodeType)}.
         * 
         * @param sourceCodeType
         *        a consumer that will call methods on {@link SourceCodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCodeType(SourceCodeType)
         */
        default Builder sourceCodeType(Consumer<SourceCodeType.Builder> sourceCodeType) {
            return sourceCodeType(SourceCodeType.builder().applyMutation(sourceCodeType).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * <code>RepositoryAssociation</code> </a> that contains the reviewed source code. You can retrieve associated
         * repository ARNs by calling <a
         * href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * <code>ListRepositoryAssociations</code> </a>.
         * </p>
         * 
         * @param associationArn
         *        The Amazon Resource Name (ARN) of the <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         *        <code>RepositoryAssociation</code> </a> that contains the reviewed source code. You can retrieve
         *        associated repository ARNs by calling <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         *        <code>ListRepositoryAssociations</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationArn(String associationArn);

        /**
         * <p>
         * The statistics from the code review.
         * </p>
         * 
         * @param metrics
         *        The statistics from the code review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Metrics metrics);

        /**
         * <p>
         * The statistics from the code review.
         * </p>
         * This is a convenience that creates an instance of the {@link Metrics.Builder} avoiding the need to create one
         * manually via {@link Metrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link Metrics.Builder#build()} is called immediately and its result is
         * passed to {@link #metrics(Metrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link Metrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(Metrics)
         */
        default Builder metrics(Consumer<Metrics.Builder> metrics) {
            return metrics(Metrics.builder().applyMutation(metrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String codeReviewArn;

        private String repositoryName;

        private String owner;

        private String providerType;

        private String state;

        private String stateReason;

        private Instant createdTimeStamp;

        private Instant lastUpdatedTimeStamp;

        private String type;

        private String pullRequestId;

        private SourceCodeType sourceCodeType;

        private String associationArn;

        private Metrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeReview model) {
            name(model.name);
            codeReviewArn(model.codeReviewArn);
            repositoryName(model.repositoryName);
            owner(model.owner);
            providerType(model.providerType);
            state(model.state);
            stateReason(model.stateReason);
            createdTimeStamp(model.createdTimeStamp);
            lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
            type(model.type);
            pullRequestId(model.pullRequestId);
            sourceCodeType(model.sourceCodeType);
            associationArn(model.associationArn);
            metrics(model.metrics);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCodeReviewArn() {
            return codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProviderType() {
            return providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final Instant getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final void setCreatedTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final SourceCodeType.Builder getSourceCodeType() {
            return sourceCodeType != null ? sourceCodeType.toBuilder() : null;
        }

        @Override
        public final Builder sourceCodeType(SourceCodeType sourceCodeType) {
            this.sourceCodeType = sourceCodeType;
            return this;
        }

        public final void setSourceCodeType(SourceCodeType.BuilderImpl sourceCodeType) {
            this.sourceCodeType = sourceCodeType != null ? sourceCodeType.build() : null;
        }

        public final String getAssociationArn() {
            return associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        public final Metrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        @Override
        public final Builder metrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final void setMetrics(Metrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public CodeReview build() {
            return new CodeReview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
