/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.Reaction;
import software.amazon.awssdk.services.codegurureviewer.model.ReactionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationFeedbackSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationFeedbackSummary> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(RecommendationFeedbackSummary.getter(RecommendationFeedbackSummary::recommendationId)).setter(RecommendationFeedbackSummary.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<List<String>> REACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reactions").getter(RecommendationFeedbackSummary.getter(RecommendationFeedbackSummary::reactionsAsStrings)).setter(RecommendationFeedbackSummary.setter(Builder::reactionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reactions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(RecommendationFeedbackSummary.getter(RecommendationFeedbackSummary::userId)).setter(RecommendationFeedbackSummary.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, REACTIONS_FIELD, USER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendationId;
    private final List<String> reactions;
    private final String userId;

    private RecommendationFeedbackSummary(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.reactions = builder.reactions;
        this.userId = builder.userId;
    }

    public String recommendationId() {
        return this.recommendationId;
    }

    public List<Reaction> reactions() {
        return ReactionsCopier.copyStringToEnum(this.reactions);
    }

    public boolean hasReactions() {
        return this.reactions != null && !(this.reactions instanceof SdkAutoConstructList);
    }

    public List<String> reactionsAsStrings() {
        return this.reactions;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactions() ? this.reactionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationFeedbackSummary)) {
            return false;
        }
        RecommendationFeedbackSummary other = (RecommendationFeedbackSummary)obj;
        return Objects.equals(this.recommendationId(), other.recommendationId()) && this.hasReactions() == other.hasReactions() && Objects.equals(this.reactionsAsStrings(), other.reactionsAsStrings()) && Objects.equals(this.userId(), other.userId());
    }

    public String toString() {
        return ToString.builder((String)"RecommendationFeedbackSummary").add("RecommendationId", (Object)this.recommendationId()).add("Reactions", this.hasReactions() ? this.reactionsAsStrings() : null).add("UserId", (Object)this.userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "Reactions": {
                return Optional.ofNullable(clazz.cast(this.reactionsAsStrings()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationFeedbackSummary, T> g) {
        return obj -> g.apply((RecommendationFeedbackSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationId;
        private List<String> reactions = DefaultSdkAutoConstructList.getInstance();
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationFeedbackSummary model) {
            this.recommendationId(model.recommendationId);
            this.reactionsWithStrings(model.reactions);
            this.userId(model.userId);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final Collection<String> getReactions() {
            if (this.reactions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reactions;
        }

        @Override
        public final Builder reactionsWithStrings(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsWithStrings(String ... reactions) {
            this.reactionsWithStrings(Arrays.asList(reactions));
            return this;
        }

        @Override
        public final Builder reactions(Collection<Reaction> reactions) {
            this.reactions = ReactionsCopier.copyEnumToString(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactions(Reaction ... reactions) {
            this.reactions(Arrays.asList(reactions));
            return this;
        }

        public final void setReactions(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public RecommendationFeedbackSummary build() {
            return new RecommendationFeedbackSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationFeedbackSummary> {
        public Builder recommendationId(String var1);

        public Builder reactionsWithStrings(Collection<String> var1);

        public Builder reactionsWithStrings(String ... var1);

        public Builder reactions(Collection<Reaction> var1);

        public Builder reactions(Reaction ... var1);

        public Builder userId(String var1);
    }
}

