/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.Match;
import software.amazon.awssdk.services.codeguruprofiler.model.MatchesCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.Pattern;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<Integer> ALL_MATCHES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allMatchesCount").getter(Recommendation.getter(Recommendation::allMatchesCount)).setter(Recommendation.setter(Builder::allMatchesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allMatchesCount").build()}).build();
    private static final SdkField<Double> ALL_MATCHES_SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("allMatchesSum").getter(Recommendation.getter(Recommendation::allMatchesSum)).setter(Recommendation.setter(Builder::allMatchesSum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allMatchesSum").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Recommendation.getter(Recommendation::endTime)).setter(Recommendation.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Pattern> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pattern").getter(Recommendation.getter(Recommendation::pattern)).setter(Recommendation.setter(Builder::pattern)).constructor(Pattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Recommendation.getter(Recommendation::startTime)).setter(Recommendation.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<Match>> TOP_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topMatches").getter(Recommendation.getter(Recommendation::topMatches)).setter(Recommendation.setter(Builder::topMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Match::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_MATCHES_COUNT_FIELD, ALL_MATCHES_SUM_FIELD, END_TIME_FIELD, PATTERN_FIELD, START_TIME_FIELD, TOP_MATCHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Recommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer allMatchesCount;
    private final Double allMatchesSum;
    private final Instant endTime;
    private final Pattern pattern;
    private final Instant startTime;
    private final List<Match> topMatches;

    private Recommendation(BuilderImpl builder) {
        this.allMatchesCount = builder.allMatchesCount;
        this.allMatchesSum = builder.allMatchesSum;
        this.endTime = builder.endTime;
        this.pattern = builder.pattern;
        this.startTime = builder.startTime;
        this.topMatches = builder.topMatches;
    }

    public final Integer allMatchesCount() {
        return this.allMatchesCount;
    }

    public final Double allMatchesSum() {
        return this.allMatchesSum;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Pattern pattern() {
        return this.pattern;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasTopMatches() {
        return this.topMatches != null && !(this.topMatches instanceof SdkAutoConstructList);
    }

    public final List<Match> topMatches() {
        return this.topMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allMatchesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.allMatchesSum());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopMatches() ? this.topMatches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.allMatchesCount(), other.allMatchesCount()) && Objects.equals(this.allMatchesSum(), other.allMatchesSum()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.startTime(), other.startTime()) && this.hasTopMatches() == other.hasTopMatches() && Objects.equals(this.topMatches(), other.topMatches());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("AllMatchesCount", (Object)this.allMatchesCount()).add("AllMatchesSum", (Object)this.allMatchesSum()).add("EndTime", (Object)this.endTime()).add("Pattern", (Object)this.pattern()).add("StartTime", (Object)this.startTime()).add("TopMatches", this.hasTopMatches() ? this.topMatches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allMatchesCount": {
                return Optional.ofNullable(clazz.cast(this.allMatchesCount()));
            }
            case "allMatchesSum": {
                return Optional.ofNullable(clazz.cast(this.allMatchesSum()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "topMatches": {
                return Optional.ofNullable(clazz.cast(this.topMatches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allMatchesCount", ALL_MATCHES_COUNT_FIELD);
        map.put("allMatchesSum", ALL_MATCHES_SUM_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("pattern", PATTERN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("topMatches", TOP_MATCHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allMatchesCount;
        private Double allMatchesSum;
        private Instant endTime;
        private Pattern pattern;
        private Instant startTime;
        private List<Match> topMatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.allMatchesCount(model.allMatchesCount);
            this.allMatchesSum(model.allMatchesSum);
            this.endTime(model.endTime);
            this.pattern(model.pattern);
            this.startTime(model.startTime);
            this.topMatches(model.topMatches);
        }

        public final Integer getAllMatchesCount() {
            return this.allMatchesCount;
        }

        public final void setAllMatchesCount(Integer allMatchesCount) {
            this.allMatchesCount = allMatchesCount;
        }

        @Override
        public final Builder allMatchesCount(Integer allMatchesCount) {
            this.allMatchesCount = allMatchesCount;
            return this;
        }

        public final Double getAllMatchesSum() {
            return this.allMatchesSum;
        }

        public final void setAllMatchesSum(Double allMatchesSum) {
            this.allMatchesSum = allMatchesSum;
        }

        @Override
        public final Builder allMatchesSum(Double allMatchesSum) {
            this.allMatchesSum = allMatchesSum;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Pattern.Builder getPattern() {
            return this.pattern != null ? this.pattern.toBuilder() : null;
        }

        public final void setPattern(Pattern.BuilderImpl pattern) {
            this.pattern = pattern != null ? pattern.build() : null;
        }

        @Override
        public final Builder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final List<Match.Builder> getTopMatches() {
            List<Match.Builder> result = MatchesCopier.copyToBuilder(this.topMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopMatches(Collection<Match.BuilderImpl> topMatches) {
            this.topMatches = MatchesCopier.copyFromBuilder(topMatches);
        }

        @Override
        public final Builder topMatches(Collection<Match> topMatches) {
            this.topMatches = MatchesCopier.copy(topMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topMatches(Match ... topMatches) {
            this.topMatches(Arrays.asList(topMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topMatches(Consumer<Match.Builder> ... topMatches) {
            this.topMatches(Stream.of(topMatches).map(c -> (Match)((Match.Builder)Match.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder allMatchesCount(Integer var1);

        public Builder allMatchesSum(Double var1);

        public Builder endTime(Instant var1);

        public Builder pattern(Pattern var1);

        default public Builder pattern(Consumer<Pattern.Builder> pattern) {
            return this.pattern((Pattern)((Pattern.Builder)Pattern.builder().applyMutation(pattern)).build());
        }

        public Builder startTime(Instant var1);

        public Builder topMatches(Collection<Match> var1);

        public Builder topMatches(Match ... var1);

        public Builder topMatches(Consumer<Match.Builder> ... var1);
    }
}

