/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDataCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDatum;
import software.amazon.awssdk.services.codeguruprofiler.model.ListOfTimestampsCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.TimestampStructure;
import software.amazon.awssdk.services.codeguruprofiler.model.UnprocessedEndTimeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFrameMetricDataResponse
extends CodeGuruProfilerResponse
implements ToCopyableBuilder<Builder, BatchGetFrameMetricDataResponse> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(BatchGetFrameMetricDataResponse.getter(BatchGetFrameMetricDataResponse::endTime)).setter(BatchGetFrameMetricDataResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<TimestampStructure>> END_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("endTimes").getter(BatchGetFrameMetricDataResponse.getter(BatchGetFrameMetricDataResponse::endTimes)).setter(BatchGetFrameMetricDataResponse.setter(Builder::endTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimestampStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FrameMetricDatum>> FRAME_METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("frameMetricData").getter(BatchGetFrameMetricDataResponse.getter(BatchGetFrameMetricDataResponse::frameMetricData)).setter(BatchGetFrameMetricDataResponse.setter(Builder::frameMetricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FrameMetricDatum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolution").getter(BatchGetFrameMetricDataResponse.getter(BatchGetFrameMetricDataResponse::resolutionAsString)).setter(BatchGetFrameMetricDataResponse.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(BatchGetFrameMetricDataResponse.getter(BatchGetFrameMetricDataResponse::startTime)).setter(BatchGetFrameMetricDataResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, List<TimestampStructure>>> UNPROCESSED_END_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("unprocessedEndTimes").getter(BatchGetFrameMetricDataResponse.getter(BatchGetFrameMetricDataResponse::unprocessedEndTimes)).setter(BatchGetFrameMetricDataResponse.setter(Builder::unprocessedEndTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedEndTimes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimestampStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, END_TIMES_FIELD, FRAME_METRIC_DATA_FIELD, RESOLUTION_FIELD, START_TIME_FIELD, UNPROCESSED_END_TIMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetFrameMetricDataResponse.memberNameToFieldInitializer();
    private final Instant endTime;
    private final List<TimestampStructure> endTimes;
    private final List<FrameMetricDatum> frameMetricData;
    private final String resolution;
    private final Instant startTime;
    private final Map<String, List<TimestampStructure>> unprocessedEndTimes;

    private BatchGetFrameMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.endTimes = builder.endTimes;
        this.frameMetricData = builder.frameMetricData;
        this.resolution = builder.resolution;
        this.startTime = builder.startTime;
        this.unprocessedEndTimes = builder.unprocessedEndTimes;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasEndTimes() {
        return this.endTimes != null && !(this.endTimes instanceof SdkAutoConstructList);
    }

    public final List<TimestampStructure> endTimes() {
        return this.endTimes;
    }

    public final boolean hasFrameMetricData() {
        return this.frameMetricData != null && !(this.frameMetricData instanceof SdkAutoConstructList);
    }

    public final List<FrameMetricDatum> frameMetricData() {
        return this.frameMetricData;
    }

    public final AggregationPeriod resolution() {
        return AggregationPeriod.fromValue(this.resolution);
    }

    public final String resolutionAsString() {
        return this.resolution;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasUnprocessedEndTimes() {
        return this.unprocessedEndTimes != null && !(this.unprocessedEndTimes instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<TimestampStructure>> unprocessedEndTimes() {
        return this.unprocessedEndTimes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndTimes() ? this.endTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameMetricData() ? this.frameMetricData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedEndTimes() ? this.unprocessedEndTimes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFrameMetricDataResponse)) {
            return false;
        }
        BatchGetFrameMetricDataResponse other = (BatchGetFrameMetricDataResponse)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && this.hasEndTimes() == other.hasEndTimes() && Objects.equals(this.endTimes(), other.endTimes()) && this.hasFrameMetricData() == other.hasFrameMetricData() && Objects.equals(this.frameMetricData(), other.frameMetricData()) && Objects.equals(this.resolutionAsString(), other.resolutionAsString()) && Objects.equals(this.startTime(), other.startTime()) && this.hasUnprocessedEndTimes() == other.hasUnprocessedEndTimes() && Objects.equals(this.unprocessedEndTimes(), other.unprocessedEndTimes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFrameMetricDataResponse").add("EndTime", (Object)this.endTime()).add("EndTimes", this.hasEndTimes() ? this.endTimes() : null).add("FrameMetricData", this.hasFrameMetricData() ? this.frameMetricData() : null).add("Resolution", (Object)this.resolutionAsString()).add("StartTime", (Object)this.startTime()).add("UnprocessedEndTimes", this.hasUnprocessedEndTimes() ? this.unprocessedEndTimes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "endTimes": {
                return Optional.ofNullable(clazz.cast(this.endTimes()));
            }
            case "frameMetricData": {
                return Optional.ofNullable(clazz.cast(this.frameMetricData()));
            }
            case "resolution": {
                return Optional.ofNullable(clazz.cast(this.resolutionAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "unprocessedEndTimes": {
                return Optional.ofNullable(clazz.cast(this.unprocessedEndTimes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endTime", END_TIME_FIELD);
        map.put("endTimes", END_TIMES_FIELD);
        map.put("frameMetricData", FRAME_METRIC_DATA_FIELD);
        map.put("resolution", RESOLUTION_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("unprocessedEndTimes", UNPROCESSED_END_TIMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFrameMetricDataResponse, T> g) {
        return obj -> g.apply((BatchGetFrameMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerResponse.BuilderImpl
    implements Builder {
        private Instant endTime;
        private List<TimestampStructure> endTimes = DefaultSdkAutoConstructList.getInstance();
        private List<FrameMetricDatum> frameMetricData = DefaultSdkAutoConstructList.getInstance();
        private String resolution;
        private Instant startTime;
        private Map<String, List<TimestampStructure>> unprocessedEndTimes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFrameMetricDataResponse model) {
            super(model);
            this.endTime(model.endTime);
            this.endTimes(model.endTimes);
            this.frameMetricData(model.frameMetricData);
            this.resolution(model.resolution);
            this.startTime(model.startTime);
            this.unprocessedEndTimes(model.unprocessedEndTimes);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<TimestampStructure.Builder> getEndTimes() {
            List<TimestampStructure.Builder> result = ListOfTimestampsCopier.copyToBuilder(this.endTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndTimes(Collection<TimestampStructure.BuilderImpl> endTimes) {
            this.endTimes = ListOfTimestampsCopier.copyFromBuilder(endTimes);
        }

        @Override
        public final Builder endTimes(Collection<TimestampStructure> endTimes) {
            this.endTimes = ListOfTimestampsCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(TimestampStructure ... endTimes) {
            this.endTimes(Arrays.asList(endTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(Consumer<TimestampStructure.Builder> ... endTimes) {
            this.endTimes(Stream.of(endTimes).map(c -> (TimestampStructure)((TimestampStructure.Builder)TimestampStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FrameMetricDatum.Builder> getFrameMetricData() {
            List<FrameMetricDatum.Builder> result = FrameMetricDataCopier.copyToBuilder(this.frameMetricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameMetricData(Collection<FrameMetricDatum.BuilderImpl> frameMetricData) {
            this.frameMetricData = FrameMetricDataCopier.copyFromBuilder(frameMetricData);
        }

        @Override
        public final Builder frameMetricData(Collection<FrameMetricDatum> frameMetricData) {
            this.frameMetricData = FrameMetricDataCopier.copy(frameMetricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameMetricData(FrameMetricDatum ... frameMetricData) {
            this.frameMetricData(Arrays.asList(frameMetricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameMetricData(Consumer<FrameMetricDatum.Builder> ... frameMetricData) {
            this.frameMetricData(Stream.of(frameMetricData).map(c -> (FrameMetricDatum)((FrameMetricDatum.Builder)FrameMetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(AggregationPeriod resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Map<String, List<TimestampStructure.Builder>> getUnprocessedEndTimes() {
            Map<String, List<TimestampStructure.Builder>> result = UnprocessedEndTimeMapCopier.copyToBuilder(this.unprocessedEndTimes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedEndTimes(Map<String, ? extends Collection<TimestampStructure.BuilderImpl>> unprocessedEndTimes) {
            this.unprocessedEndTimes = UnprocessedEndTimeMapCopier.copyFromBuilder(unprocessedEndTimes);
        }

        @Override
        public final Builder unprocessedEndTimes(Map<String, ? extends Collection<TimestampStructure>> unprocessedEndTimes) {
            this.unprocessedEndTimes = UnprocessedEndTimeMapCopier.copy(unprocessedEndTimes);
            return this;
        }

        @Override
        public BatchGetFrameMetricDataResponse build() {
            return new BatchGetFrameMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFrameMetricDataResponse> {
        public Builder endTime(Instant var1);

        public Builder endTimes(Collection<TimestampStructure> var1);

        public Builder endTimes(TimestampStructure ... var1);

        public Builder endTimes(Consumer<TimestampStructure.Builder> ... var1);

        public Builder frameMetricData(Collection<FrameMetricDatum> var1);

        public Builder frameMetricData(FrameMetricDatum ... var1);

        public Builder frameMetricData(Consumer<FrameMetricDatum.Builder> ... var1);

        public Builder resolution(String var1);

        public Builder resolution(AggregationPeriod var1);

        public Builder startTime(Instant var1);

        public Builder unprocessedEndTimes(Map<String, ? extends Collection<TimestampStructure>> var1);
    }
}

