/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the ListFindingsReportsRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsReportsRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<ListFindingsReportsRequest.Builder, ListFindingsReportsRequest> {
    private static final SdkField<Boolean> DAILY_REPORTS_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dailyReportsOnly").getter(getter(ListFindingsReportsRequest::dailyReportsOnly))
            .setter(setter(Builder::dailyReportsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dailyReportsOnly").build())
            .build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ListFindingsReportsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFindingsReportsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsReportsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(ListFindingsReportsRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ListFindingsReportsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_REPORTS_ONLY_FIELD,
            END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));

    private final Boolean dailyReportsOnly;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private final String profilingGroupName;

    private final Instant startTime;

    private ListFindingsReportsRequest(BuilderImpl builder) {
        super(builder);
        this.dailyReportsOnly = builder.dailyReportsOnly;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to
     * <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis
     * data is returned from smaller time windows (for example, one hour).
     * </p>
     * 
     * @return A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to
     *         <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
     *         analysis data is returned from smaller time windows (for example, one hour).
     */
    public final Boolean dailyReportsOnly() {
        return dailyReportsOnly;
    }

    /**
     * <p>
     * The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
     * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
     *         <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     *         represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output. When this
     * parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code> results in a single page
     * along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>ListFindingsReports</code> request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output.
     *         When this parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code>
     *         results in a single page along with a <code>nextToken</code> response element. The remaining results of
     *         the initial request can be seen by sending another <code>ListFindingsReports</code> request with the
     *         returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code>
     * request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     * continues from the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>ListFindingsReportsRequest</code> request where <code>maxResults</code> was used and the results
     *         exceeded the value of that parameter. Pagination continues from the end of the previous results that
     *         returned the <code>nextToken</code> value. </p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the profiling group from which to search for analysis data.
     * </p>
     * 
     * @return The name of the profiling group from which to search for analysis data.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
     * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
     *         <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     *         represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dailyReportsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsReportsRequest)) {
            return false;
        }
        ListFindingsReportsRequest other = (ListFindingsReportsRequest) obj;
        return Objects.equals(dailyReportsOnly(), other.dailyReportsOnly()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsReportsRequest").add("DailyReportsOnly", dailyReportsOnly())
                .add("EndTime", endTime()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ProfilingGroupName", profilingGroupName()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dailyReportsOnly":
            return Optional.ofNullable(clazz.cast(dailyReportsOnly()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsReportsRequest, T> g) {
        return obj -> g.apply((ListFindingsReportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFindingsReportsRequest> {
        /**
         * <p>
         * A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to
         * <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis
         * data is returned from smaller time windows (for example, one hour).
         * </p>
         * 
         * @param dailyReportsOnly
         *        A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to
         *        <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>,
         *        analysis data is returned from smaller time windows (for example, one hour).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyReportsOnly(Boolean dailyReportsOnly);

        /**
         * <p>
         * The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
         * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
         * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param endTime
         *        The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
         *        <code>endTime</code>. This is specified using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output. When
         * this parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code> results in a
         * single page along with a <code>nextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>ListFindingsReports</code> request with the returned
         * <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output.
         *        When this parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code>
         *        results in a single page along with a <code>nextToken</code> response element. The remaining results
         *        of the initial request can be seen by sending another <code>ListFindingsReports</code> request with
         *        the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>ListFindingsReportsRequest</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value. </p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the profiling group from which to search for analysis data.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group from which to search for analysis data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
         * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
         * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param startTime
         *        The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
         *        <code>endTime</code>. This is specified using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private Boolean dailyReportsOnly;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private String profilingGroupName;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsReportsRequest model) {
            super(model);
            dailyReportsOnly(model.dailyReportsOnly);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            profilingGroupName(model.profilingGroupName);
            startTime(model.startTime);
        }

        public final Boolean getDailyReportsOnly() {
            return dailyReportsOnly;
        }

        public final void setDailyReportsOnly(Boolean dailyReportsOnly) {
            this.dailyReportsOnly = dailyReportsOnly;
        }

        @Override
        public final Builder dailyReportsOnly(Boolean dailyReportsOnly) {
            this.dailyReportsOnly = dailyReportsOnly;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingsReportsRequest build() {
            return new ListFindingsReportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
